package com.zbank.file.sdk.deprecated;

import com.zbank.file.bean.AsyncDownLoadInfo;
import com.zbank.file.exception.EmptyFileException;
import com.zbank.file.exception.SDKException;

/**
 * 异步下载流接口，因其使用上的局限性和风险性，单独列出，并且不建议使用。
 * 
 * @author zhanglulu
 *
 */
@Deprecated
public interface IAsyncDownLoadStreamSDK {

	
	/**
	 * 全景图缓存文件分片流下载，基本用法如下：</br>
	 * <pre>{@code
	 * SDK sdk = SDK.build(....);
	 * AsyncDownLoadInfo downloadInfo = sdk.fileAsyncDownLoadWithMutiTask(....);
	 * ICachedInputStream inputStream = downloadInfo.getInputStream();
	 * File destFile = ....
	 * for(int i =0 ;i < inputStream.available0(); i++){//循环获取文件分片数据
	 *   try{//<b>必须进行try catch保证能成功完成全部循环，否则线程会挂死</b>
	 *      byte[] bytes = inputStream.read0();//获取文件第i片的字节数组
	 *      //将bytes写进destFile
	 *   }catch(Exception e){
	 *     //<b>异常处理，不可抛出异常!!!!</b>
	 *   }
	 * }
	 * String md5 = Md5EncodeUtil.encode(destFile);
	 * if(md5.equals(inputStream.getFileMD5())){
	 *  //文件下载成功
	 *  //TODO 下载成功后的处理逻辑
	 * }else{
	 *  //文件下载失败
	 *  //TODO 下载失败后的处理逻辑
	 * }
	 * </pre>
	 * <b>注意：在循环体中必须将所有的分片输数据取完，否则会造成线程挂起。在取完之后最好做MD5校验，保证文件的正确性!!</br></br>
	 * 
	 * @param fileId 文件唯一标识
	 * @param channelId 渠道编号
	 * @param concurrency 异步下载并发数。建议最小不低于2，最大不超过AbstractSDK.PERMIT_MAX(默认值为4)。
	 * @param seqNo 流水号
	 * @return
	 * @throws SDKException
	 * @throws EmptyFileException 当所下载的文件大小为0(即当初所上传的文件为空文件)时，将抛出该异常。
	 */
	@Deprecated
	public AsyncDownLoadInfo fileAsyncDownLoadWithPicBuffer(String fileId,String channelId, int concurrency,String seqNo) throws SDKException,EmptyFileException;
	
	/**
	 * 多任务异步文件分片流下载，基本用法如下：</br>
	 * <pre>{@code
	 * SDK sdk = SDK.build(....);
	 * AsyncDownLoadInfo downloadInfo = sdk.fileAsyncDownLoadWithMutiTask(....);
	 * ICachedInputStream inputStream = downloadInfo.getInputStream();
	 * File destFile = ....
	 * for(int i =0 ;i < inputStream.available0(); i++){//循环获取文件分片数据
	 *   try{//<b>必须进行try catch保证能成功完成全部循环，否则线程会挂死</b>
	 *      byte[] bytes = inputStream.read0();//获取文件第i片的字节数组
	 *      //将bytes写进destFile
	 *   }catch(Exception e){
	 *     //<b>异常处理，不可抛出异常!!!!</b>
	 *   }
	 * }
	 * String md5 = Md5EncodeUtil.encode(destFile);
	 * if(md5.equals(inputStream.getFileMD5())){
	 *  //文件下载成功
	 *  //TODO 下载成功后的处理逻辑
	 * }else{
	 *  //文件下载失败
	 *  //TODO 下载失败后的处理逻辑
	 * }
	 * </pre>
	 * <b>注意：在循环体中必须将所有的分片输数据取完，否则会造成线程挂起。在取完之后最好做MD5校验，保证文件的正确性!!</br></br>
	 * 
	 * @param fileId 文件唯一标识
	 * @param channelId 渠道编号
	 * @param concurrency 异步下载并发数。建议最小不低于2，最大不超过AbstractSDK.PERMIT_MAX(默认值为4)。
	 * @param seqNo 流水号
	 * @return
	 * @throws SDKException
	 * @throws EmptyFileException 当所下载的文件大小为0(即当初所上传的文件为空文件)时，将抛出该异常。
	 */
	@Deprecated
	public AsyncDownLoadInfo fileAsyncDownLoadWithMutiTask(String fileId,String channelId, int concurrency,String seqNo) throws SDKException,EmptyFileException;
}
