package com.zbank.file.sdk.download.async.impl1;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.zbank.file.bean.FileInfo;
import com.zbank.file.sdk.download.async.AbstractInputStream;
import com.zbank.file.sdk.download.async.ICachedInputStream;

/**
 * 
 * @author zhanglulu
 *
 */
public class CachedFileInputStream extends AbstractInputStream implements ICachedInputStream{

	static final Logger log = LoggerFactory.getLogger(CachedFileInputStream.class);
	private int cacheSize = 5;
	private SplitInfo[] CACHE;
	private int splitSum;
	private int readIndex = 0;
	private FileInfo fileInfo;
	boolean isOver = false;

	public CachedFileInputStream(FileInfo fileInfo) {
		CACHE = new SplitInfo[cacheSize];
		this.fileInfo = fileInfo;
		this.splitSum = this.fileInfo.getSplitSum();
		for (int i = 0; i < CACHE.length; i++) {
			SplitInfo bean = new SplitInfo();
			initSplitInfo(bean, i);
			CACHE[i] = bean;
		}
	}

	public CachedFileInputStream(int cacheSize, FileInfo fileInfo) {
		this.cacheSize = cacheSize;
		this.fileInfo = fileInfo;
		this.splitSum = this.fileInfo.getSplitSum();
		CACHE = new SplitInfo[cacheSize];
		for (int i = 0; i < CACHE.length; i++) {
			SplitInfo bean = new SplitInfo();
			initSplitInfo(bean, i);
			CACHE[i] = bean;
		}
	}
	
	

	private void initSplitInfo(SplitInfo bean, int initIndex) {
		bean.setDataPackage(null);
		bean.setReadable(false);
		bean.setWritable(true);
		bean.setLock(new Object());
		bean.setInitIndex(initIndex);
		bean.setStep(cacheSize);
		bean.setMaxIndex(splitSum);
	}

	public byte[] read0() {
		byte[] result = null;
		if (readIndex < splitSum) {
			SplitInfo bean = CACHE[readIndex % cacheSize];
			synchronized (bean.lock) {
				try {
					if (!isOver) {
						while (!bean.readable) {
							try {
								bean.lock.wait();
							} catch (Exception e) {
								log.error(e.getMessage());
							}
						}
						if (bean.dataPackage != null && bean.dataPackage.getSplitBytes() != null) {
							result = bean.dataPackage.getSplitBytes();
							log.info("第{}片文件读取成功", readIndex);
						} else {
							isOver = true;
						}
					}
				} catch (Exception e) {
					isOver = true;
					log.error(e.getMessage(),e);
				}finally {
					readIndex++;
					bean.readable = false;
					bean.writable = true;
					bean.dataPackage = null;
					try {
						bean.lock.notifyAll();
					} catch (Exception e) {
						log.error(e.getMessage());
					}
				}
			}
		}
		return result;
	}

	
	public int getCacheSize() {
		return cacheSize;
	}
	
	public SplitInfo getSpecifiedElement(int index) {
		return this.CACHE[index];
	}

	@Override
	public String getFileMD5() {
		return this.fileInfo.getFileMd5();
	}

	@Override
	public int available0() {
		return this.splitSum;
	}

	
	public FileInfo getFileInfo() {
		return fileInfo;
	}
}
