package com.zbank.file.sdk.download.async.impl2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Permit {

	static final Logger log = LoggerFactory.getLogger(Permit.class);
	int limit;
	int permit;

	public Permit(int limit, int permit) {
		this.limit = limit;
		this.permit = permit;
	}

	public synchronized void decrease() {
		while (permit - 1 < 0) {
			try {
				wait();
			} catch (InterruptedException e) {
				log.error(e.getMessage(), e);
			}
		}
		permit -= 1;
		try {
			notifyAll();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}

	}

	public synchronized void increase(){
		while (permit + 1 > limit) {
			try {
				wait();
			} catch (InterruptedException e) {
				log.error(e.getMessage(), e);
			}
		}
		permit += 1;

		try {
			notifyAll();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
	}
}