package com.zbank.file.sdk.download.image;


import com.zbank.file.bean.FileInfo;
import com.zbank.file.bean.ImageInfo;
import com.zbank.file.sdk.download.async.ICachedInputStream;


public class ImageByteArrayInputStream implements ICachedInputStream {

	private ImageInfo fileInfo;

	public ImageByteArrayInputStream(ImageInfo fileInfo) {
		this.fileInfo = fileInfo;
	}

	@Override
	public byte[] read0() {
		return this.fileInfo.getBytes();
	}

	@Override
	public String getFileMD5() {
		return this.fileInfo.getFileMd5();
	}

	@Override
	public int available0() {
		return this.fileInfo.getSplitSum();
	}

	@Override
	public FileInfo getFileInfo() {
		return this.fileInfo;
	}

}
