package com.zbank.file.sdk.download.split;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSplitDownLoad {

	private static final Logger log = LoggerFactory.getLogger(ParallelSplitDownLoad.class);
	private static ThreadPoolExecutor exService = new ThreadPoolExecutor(0, 100, 120, TimeUnit.SECONDS,
			new LinkedBlockingQueue<Runnable>(10000), new RejectedExecutionHandler() {

				@Override
				public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
					log.info("添加下载任务失败---启动新线程处理");
					new Thread(r).start();
				}
			});
	
	
	
	public static void submit(FileSplitDownLoadTask task) {
		exService.submit(task);
	}
}
