package com.zbank.file.sdk.upload;

import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.zbank.file.common.utils.FutureTaskUtil;

public class ParallelSplitUpload {
	
	private static final Logger log = LoggerFactory.getLogger(ParallelSplitUpload.class);
	private static ThreadPoolExecutor exService = new ThreadPoolExecutor(0, 100, 120, TimeUnit.SECONDS,
			new LinkedBlockingQueue<Runnable>(1000), new RejectedExecutionHandler() {

				@Override
				public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
					log.info("添加上传任务失败---上传任务队列已满，尝试丢弃当前任务");
					SplitUploadTask task = FutureTaskUtil.getTask((FutureTask<?>) r);
					if (task == null) {
						log.error("添加上传任务失败---当前任务丢弃失败，尝试丢弃老任务.");
						task = FutureTaskUtil.getTask((FutureTask<?>) executor.getQueue().poll());
						task.countDown();
						executor.execute(r);
						log.info("添加上传任务失败---老任务丢弃成功");
					} else {
						task.countDown();
						log.info("添加上传任务失败---当前任务丢弃成功");
					}
				}
			});
	
	
	
	public static void submit(SplitUploadTask task) {
		exService.submit(task);
	}
	

}
