package com.zbank.file.demo;

import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;

import com.zbank.file.common.http.config.HttpConfig;
import com.zbank.file.sdk.IImgSDK;
import com.zbank.file.sdk.ImgSDK;
import com.zbank.file.secure.SM2SM4PackSecure;

public class ImgSDKDemo {
	private static final String url = "http://localhost:8088";
	/**
	 * 渠道唯一标识（由众邦银行提供）
	 */
	private static final String channelId = "12301";
	/**
	 * /** 用于加密的密钥（由众邦银行提供），行外渠道加密使用
	 */
	private static final String encryptKey = "0463455a993b27010c80ceaca36f8faddcc5bb942b242faad8196ccda08d9ba556a669d6682d62d5278dbdc7a65d87ea8071635825725c35b92607eb379b369949";
	/**
	 * 用于加密的校验和字符串（由众邦银行提供），行外渠道加密使用
	 */
	private static final String cksStr = "UQYWEIOQWYEIQWIUEIQYWEYIHDIASD";

	private static IImgSDK sdk;

	static {
		// 1、初始化配置服务方接口url。
		sdk = ImgSDK.build(url);
		// 2、配置httpClient相关参数：连接超时时间、响应超时时间、http代理、SS5代理等。详见HttpConfig类
		HttpConfig config = new HttpConfig();
		config.setSocketTimeout(120000);
		sdk.config(config);
		// 3、 配置加解密参数
		sdk.config(new SM2SM4PackSecure(encryptKey, cksStr));
	}

	public static void main(String[] args) throws Exception{
		File f = new File("c:\\sffzm.jpg");
		byte[] fileContent = new byte[(int)f.length()];
		FileInputStream fin  = new FileInputStream(f);
		fin.read(fileContent);
		//上传小文件到影像平台
		String fileId = sdk.uploadSmallFile2ImageSys(channelId, ".jpg", UUID.randomUUID().toString(), "sffzm", fileContent, null);
		fin.close();
		System.out.println("fileId ="+fileId);
		//通过fileId下载影像文件
		sdk.downloadSmallFileFromImageSys(channelId, fileId);

	}

}
