package com.zbank.file.sdk;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.zbank.file.bean.ImageInfo;
import com.zbank.file.bean.StreamDownLoadInfo;
import com.zbank.file.common.http.config.HttpConfig;
import com.zbank.file.exception.SDKException;
import com.zbank.file.secure.IPackSecure;

/**
 * 众邦影像平台上传下载接口
 * 
 * @author zhanglulu
 *
 */
public interface IImgSDK {
	

	/**
	 * 上传大文件到众邦银行影像平台
	 * 
	 * @param channelId 渠道编号
	 * @param file 待上传文件
	 * @param uploadParam 上传文件附带的参数
	 * @return
	 * @throws SDKException
	 */
	public Map<String,Object> uploadBigFile2ImageSys(String channelId,File file,HashMap<String,Object> uploadParam)throws SDKException;
	
	/**
	 * 上传大文件二进制字节数组到众邦银行影像平台
	 * @param channelId 渠道编号
	 * @param fileData 文件的二进制数据
	 * @param fileName 文件名称，必须带有后缀名，例如：计算机系统原理.pdf
	 * @param uploadParam 上传文件附带的参数
	 * @return
	 * @throws SDKException
	 */
	public Map<String,Object> uploadBigFile2ImageSys(String channelId,byte[] fileData,String fileName,HashMap<String,Object> uploadParam)throws SDKException;
	
	/**
	 * 从影像平台下载大文件。基本用法如下
	 * <pre>{@code
	 * ImgSDK sdk = ImgSDK.build(....);
	 * StreamDownLoadInfo downloadInfo = null;
	 * try{
	 * 	downloadInfo = sdk.downloadBigFileFromImageSys(....);
	 * 	byte[] bytes = new byte[...]
	 * 	//以下为循环读取输入流中的数据，直到读取结束为止
	 *	int n = downloadInfo.read(bytes);
	 * 	File destFile = ....
	 * 	while(n != -1){
	 *	   //TODO 你自己的代码，对读取的数据进行处理
	 *	   n = downloadInfo.read(bytes);
	 * 	}
	 * }catch(Exception e){
	 * 	//TODO 这里是你的异常处理逻辑....
	 * }finally{
	 *	<b>//完成之后一定要调用StreamDownLoadInfo.releaseResouces();方法释放资源!!!!</b>
	 * 	if(downloadInfo != null){
	 *	   downloadInfo.releaseResouces();
	 * 	}
	 * }
	 * </pre>
	 * @param channelId 渠道编号
	 * @param fileUrl 文件在众邦影像平台的url地址
	 * @return
	 * @throws SDKException
	 */
	public StreamDownLoadInfo downloadBigFileFromImageSys(String channelId,String fileUrl)throws SDKException;
	
	/**
	 * 从影像平台下载小文件(影像平台2002、L2005影像下载接口)，返回文件信息
	 * 
	 * @param channelId 渠道编号
	 * @param fileHandle 要下载的文件句柄：一个URL串或者一个含有空格的FileId串
	 * @return
	 * @throws SDKException
	 */
	public ImageInfo downloadSmallFileFromImageSys(String channelId,String fileHandle)throws SDKException;
	
	/**
	 * 上传小文件到影像平台(影像平台2001接口),并返回文件的fileId(一个含有空格的字符串，格式为：影像平台文件ID 业务流水号)
	 * 
	 * @param channelId 渠道编号
	 * @param fileType 文件类型，jpg、 png、 mp3、 avi、 zip、 rar、pdf、 word、 excel、 txt 等
	 * @param busiNo 与文件关联的业务流水号
	 * @param billType 文件的业务类型，比如：sfzzm 身份证正面、sfzfm 身份证反面等，详见接口文档.
	 * @param fileBytes 文件的二进制数据
	 * @param extInfo 其他补充信息
	 * @return
	 * @throws SDKException
	 */
	public String uploadSmallFile2ImageSys(String channelId,String fileType,String busiNo,String billType,byte[] fileBytes,Map<String,String> extInfo)throws SDKException;
	
	
	/**
	 * 配置SDK的http选项
	 * 
	 * @param httpConfig
	 * @return
	 */
	public IImgSDK config(HttpConfig httpConfig) ;

	/**
	 * 配置SDK的加密方案实例
	 * 
	 * @param packScure
	 * @return
	 */
	public IImgSDK config(IPackSecure packScure) ;
}
