package com.zbank.file.sdk.download.async;

import com.zbank.file.bean.FileInfo;

public interface ICachedInputStream {
	
	/**
	 * 按顺序读取当前文件片的字节数组。用法如下：
	 * <pre>{@code
	 * ICachedInputStream inputStream =....
	 * File destFile = ....
	 * for(int i =0 ;i < inputStream.available0(); i++){//循环获取文件分片数据
	 *   try{//必须进行try catch保证能成功完成全部循环，否则线程会挂死
	 *      byte[] bytes = inputStream.read0();//获取文件第i片的字节数组
	 *      //将bytes写进destFile
	 *   }catch(Exception e){
	 *     //异常处理，不可抛出异常
	 *   }
	 * }
	 * String md5 = Md5EncodeUtil.encode(destFile);
	 * if(md5.equals(inputStream.getFileMD5())){
	 *  //文件下载成功
	 *  //TODO 下载成功后的处理逻辑
	 * }else{
	 *  //文件下载失败
	 *  //TODO 下载失败后的处理逻辑
	 * }
	 * </pre>
	 * <b>注意：在循环体中必须将所有的分片输数据取完，否则会造成线程挂起。在取完之后最好做MD5校验，保证文件的正确性!!</br>
	 * @return 如果读取正常则返回当前片字节数组，否则返回null
	 */
	public byte[] read0();
	/**
	 * 获取文件的MD5。
	 * @return
	 */
	public String getFileMD5();
	/**
	 * 获取文件片总数
	 * @return
	 */
	public int available0();
	
	/**
	 * 获取文件描述信息
	 * @return
	 */
	public FileInfo getFileInfo();
}
