package com.zbank.file.sdk.download.async.impl2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.zbank.file.bean.FileInfo;
import com.zbank.file.sdk.download.async.AbstractInputStream;
import com.zbank.file.sdk.download.async.ICachedInputStream;

/**
 * 
 * @author zhanglulu
 *
 */
public class CachedFileInputStream extends AbstractInputStream implements ICachedInputStream{

	static final Logger log = LoggerFactory.getLogger(CachedFileInputStream.class);
	private SplitInfo[] CACHE;
	private int splitSum;
	private int readIndex = 0;
	private FileInfo fileInfo;
	private Permit permit;
	
	private Status status;

	public CachedFileInputStream(FileInfo fileInfo,Permit permit,Status status) {
		CACHE = new SplitInfo[fileInfo.getSplitSum()];
		this.fileInfo = fileInfo;
		this.permit = permit;
		this.status = status;
		this.splitSum = this.fileInfo.getSplitSum();
		for (int i = 0; i < CACHE.length; i++) {
			SplitInfo bean = new SplitInfo();
			initSplitInfo(bean);
			CACHE[i] = bean;
		}
	}
	

	private void initSplitInfo(SplitInfo bean) {
		bean.lock = new Object();
	}

	public byte[] read0() {
		byte[] result = null;
		if (readIndex < splitSum) {
			SplitInfo bean = CACHE[readIndex];
			synchronized (bean.lock) {
				try {
					if (!status.isOver) {
						while (bean.dataPackage == null) {
							try {
								bean.lock.wait();
							} catch (Exception e) {
								log.error(e.getMessage());
							}
						}
						result = bean.dataPackage.getSplitBytes();
						if (result == null) {
							status.isOver = true;
						}
					}
				} catch (Exception e) {
					log.error(e.getMessage(), e);
					status.isOver = true;
				} finally {
					readIndex++;
					if (bean != null && bean.dataPackage != null) {
						bean.dataPackage.setSplitBytes(null);
					}
					/*
					 * try { bean.lock.notifyAll(); } catch (Exception e) { log.error(e.getMessage()); }
					 */		
				}
			}
			permit.increase();
		}
		return result;
	}
	
	public SplitInfo[] getCache() {
		return this.CACHE;
	}

	@Override
	public String getFileMD5() {
		return this.fileInfo.getFileMd5();
	}


	@Override
	public int available0() {
		// TODO Auto-generated method stub
		return this.splitSum;
	}
	public FileInfo getFileInfo() {
		return fileInfo;
	}
}
