package com.zbank.file.sdk.download.split;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

import com.zbank.file.api.APIService;
import com.zbank.file.bean.FileInfo;
import com.zbank.file.bean.SplitDownLoadRequest;
import com.zbank.file.bean.SplitDownLoadResponse;
import com.zbank.file.common.http.config.HttpConfig;
import com.zbank.file.common.utils.Md5EncodeUtil;
import com.zbank.file.constants.DealCode;
import com.zbank.file.secure.IPackSecure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSplitDownLoadTask implements Runnable {
	private static final Logger log = LoggerFactory.getLogger(FileSplitDownLoadTask.class);
	private String destDir;
	private FileInfo fileInfo;
	private int splitCurrNo;
	private HttpConfig httpConfig ;
	private IPackSecure packScure ;
	private byte[] downloadResultMap;
	private String seqNo;
	private APIService apiService;
	private CountDownLatch countDownLatch;
	private String channelId;
	
	public FileSplitDownLoadTask(String destDir,FileInfo fileInfo,int splitCurrNo,String seqNo,byte[] downloadResultMap,CountDownLatch countDownLatch,HttpConfig httpConfig,IPackSecure packScure,APIService apiService,String channelId) {
		this.destDir = destDir;
		this.fileInfo = fileInfo;
		this.splitCurrNo =  splitCurrNo;
		this.httpConfig = httpConfig;
		this.packScure = packScure;
		this.downloadResultMap = downloadResultMap;
		this.seqNo = seqNo;
		this.apiService = apiService;
		this.countDownLatch = countDownLatch;
		this.channelId = channelId;
		
	}
	
	@Override
	public void run() {
		try {
			String fileId = fileInfo != null ? fileInfo.getFileId() : "";
			File destSplitFile = new File(destDir + File.separator + fileId + "_" + splitCurrNo + ".temp");
			if (destSplitFile.exists()) {
				downloadResultMap[splitCurrNo] = (byte) 1;
				return;
			}
			SplitDownLoadRequest downloadRequest = new SplitDownLoadRequest();
			downloadRequest.setChannelId(this.channelId);
			downloadRequest.setFileId(fileInfo.getFileId());
			downloadRequest.setSeqNo(seqNo);
			downloadRequest.setCurrSplitNo(String.valueOf(splitCurrNo));
			SplitDownLoadResponse splitResponse = this.apiService.splitDownLoad(downloadRequest, this.httpConfig,
					this.packScure);
			if (DealCode.SUCCESS.getCode().equals(splitResponse.getCode())) {
				String md5 = splitResponse.getSplitDownLoadInfo().getSplitMd5();
				File tempFile = new File(destDir + File.separator + fileId + "_" + splitCurrNo + ".temp"
						+ UUID.randomUUID().toString().replaceAll("-", ""));
				BufferedOutputStream bou = null;
				try {
					bou = new BufferedOutputStream(new FileOutputStream(tempFile));
					bou.write(splitResponse.getSplitDownLoadInfo().getSplitBytes());
					bou.flush();
				} catch (Exception e) {
					log.error(e.getMessage(), e);
				} finally {
					if (bou != null) {
						bou.close();
					}
				}
				if (tempFile.exists() && Md5EncodeUtil.encode(tempFile).equals(md5) && renameFile(tempFile, destSplitFile, 0)) {
					downloadResultMap[splitCurrNo] = (byte) 1;
				}else{
					deleteFile(tempFile, 0);
					log.error("文件" + this.fileInfo.getFileId() +"分片[" + splitCurrNo + "]下载失败");
				}
			}else{
				log.error("文件" + this.fileInfo.getFileId() +"分片[" + splitCurrNo + "]下载失败");
			}
		} catch (Exception e) {
			log.error("文件" + this.fileInfo.getFileId() +"分片[" + splitCurrNo + "]下载失败", e);
		} finally {
			this.countDown();
		}
	}
	
	public static boolean renameFile(File oldfile, File newfile, int tryTimes) {
		if (tryTimes > 4) {
			return false;
		}
		try {
			// 如果已经存在了，则直接删掉以前的旧文件
			if (newfile.exists()) {
				if (oldfile.exists()) {
					if (oldfile.delete()) {
						return true;
					}
				} else {
					return true;
				}
			} else {
				if (oldfile.renameTo(newfile)) {
					return true;
				}
			}
		} catch (Exception e) {
		}
		try {
			Thread.sleep(1 * (tryTimes + 1));
		} catch (InterruptedException e1) {
		}
		return renameFile(oldfile, newfile, ++tryTimes);
	}
	
	public static void deleteFile(File file, int tryTimes) {
		if (tryTimes > 4) {
			return;
		}
		try {
			if (!file.exists()) {
				return;
			}
			if (file.delete()) {
				return;
			}
		} catch (Exception e) {
		}
		try {
			Thread.sleep(1 * (tryTimes + 1));
		} catch (InterruptedException e1) {
		}
		deleteFile(file, ++tryTimes);
	}
	
	public void countDown() {
		if(countDownLatch != null) {
			try {
				this.countDownLatch.countDown();
			}catch(Exception e) {
			}
			
		}
	}

}
