package com.zbank.file.sdk.download.sync;

import java.util.UUID;

import com.zbank.file.api.APIService;
import com.zbank.file.bean.FileInfo;
import com.zbank.file.bean.FileQueryResponse;
import com.zbank.file.bean.SplitDownLoadRequest;
import com.zbank.file.bean.SplitDownLoadResponse;
import com.zbank.file.common.http.config.HttpConfig;
import com.zbank.file.constants.DealCode;
import com.zbank.file.exception.SDKException;
import com.zbank.file.secure.IPackSecure;

public class SplitIterator {
	private FileQueryResponse fileResponse;
	private APIService apiService;
	private HttpConfig httpConfig;
	private IPackSecure packScure;
	private String channelId;
	/**
	 * 迭代器读指针，代表当前下载的分片位置
	 */
	private int readIndex = -1;
	
	public SplitIterator(FileQueryResponse fileResponse,APIService apiService,HttpConfig httpConfig,IPackSecure packScure,String channelId){
		this.fileResponse = fileResponse;
		this.apiService = apiService;
		this.httpConfig = httpConfig;
		this.packScure = packScure;
		this.channelId = channelId;
	}

	/**
	 * 下载下一文件分片。
	 * 
	 * @return
	 * @throws SDKException
	 */
	public byte[] next() throws SDKException {
		this.readIndex++;
		return download();
	}
	
	/**
	 * 重试下载当文件前片
	 * 
	 * @return
	 * @throws SDKException
	 */
	public byte[] retry() throws SDKException {
		return download();
	}

	/**
	 * 是否还有下一片
	 * 
	 * @return
	 */
	public boolean hasNext() {
		return this.readIndex + 1 < fileResponse.getFileInfo().getSplitSum();
	}

	/**
	 * 返回该文件的信息
	 * @return
	 */
	public FileInfo getFileInfo() {
		return fileResponse.getFileInfo();
	}
	
	/**
	 * 下载第i片
	 * @param i
	 * @return
	 * @throws SDKException
	 */
	private byte[] download() throws SDKException {
		if (this.readIndex >= this.fileResponse.getFileInfo().getSplitSum()) {
			throw new SDKException("下载文件分片[" + this.readIndex + "]失败，原因：所下载的分片序号大于整个文件的分片数量！！");
		}
		if (this.readIndex < 0) {
			throw new SDKException("下载文件分片[" + this.readIndex + "]失败，原因：所下载的分片序号小于0！！");
		}
		try {
			SplitDownLoadRequest request = new SplitDownLoadRequest();
			request.setChannelId(this.channelId);
			request.setCurrSplitNo(String.valueOf(this.readIndex));
			request.setFileId(this.fileResponse.getFileInfo().getFileId());
			request.setSeqNo(UUID.randomUUID().toString());
			SplitDownLoadResponse response = this.apiService.splitDownLoad(request, this.httpConfig, this.packScure);
			if (DealCode.SUCCESS.getCode().equals(response.getCode())) {
				return response.getSplitDownLoadInfo().getSplitBytes();
			} else {
				throw new SDKException(response.getCode(), response.getMessge());
			}
		} catch (Exception e) {
			if (e instanceof SDKException) {
				throw (SDKException) e;
			}
			throw new SDKException(DealCode.SDK_ERROR.getCode(), e);
		}
	}
}
