package com.zbank.file.sdk.upload;

import java.util.concurrent.CountDownLatch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.zbank.file.api.APIService;
import com.zbank.file.bean.UploadRequest;
import com.zbank.file.bean.UploadResponse;
import com.zbank.file.common.http.config.HttpConfig;
import com.zbank.file.constants.DealCode;
import com.zbank.file.sdk.download.async.impl2.Permit;
import com.zbank.file.secure.IPackSecure;

public class SplitUploadTask implements Runnable {

	private static final Logger log = LoggerFactory.getLogger(SplitUploadTask.class);
	private UploadRequest splitUp;
	private HttpConfig httpConfig;
	private IPackSecure packScure;
	private APIService apiService; 
	private byte[] uploadResultMap;
	private CountDownLatch countDownLatch;
	private Permit permit;
	public SplitUploadTask(UploadRequest splitUp, byte[] uploadResultMap,HttpConfig httpConfig,IPackSecure packScure,APIService apiService,CountDownLatch countDownLatch,Permit permit) {
		this.httpConfig = httpConfig;
		this.packScure = packScure;
		this.splitUp = splitUp;
		this.apiService = apiService;
		this.uploadResultMap = uploadResultMap;
		this.countDownLatch = countDownLatch;
		this.permit = permit;
	}
	
	@Override
	public void run() {
		try {
			UploadResponse upResponse = this.apiService.splitUpload(splitUp, this.httpConfig, this.packScure);
			if (DealCode.SUCCESS.getCode().equals(upResponse.getCode())) {
				uploadResultMap[Integer.parseInt(this.splitUp.getCurrSplitNo())] = (byte) 1;
			}else{
				uploadResultMap[Integer.parseInt(this.splitUp.getCurrSplitNo())] = (byte) 0;
				log.error("文件" + this.splitUp.getFileId() + ",第" + this.splitUp.getCurrSplitNo() + "片，上传失败!原因："+upResponse.getMessage());
			}
		} catch (Exception e) {
			uploadResultMap[Integer.parseInt(this.splitUp.getCurrSplitNo())] = (byte) 0;
			log.error("文件" + this.splitUp.getFileId() + ",第" + this.splitUp.getCurrSplitNo() + "片，上传失败!" , e);
		} finally {
			this.increase();
			this.countDown();
		}
	}
	
	public void increase() {
		if(permit != null) {
			try {
				this.permit.increase();
			}catch(Exception e) {
			}
		}
	}
	
	public void countDown() {
		if(countDownLatch != null) {
			try {
				this.countDownLatch.countDown();
			}catch(Exception e) {
			}
			
		}
	}
	

}
