package com.zbank.file.secure;

import java.util.Map;

import com.zbank.file.exception.SDKException;

public interface IPackSecure {
	/**
	 * 获取加密模式
	 * @return
	 */
	String getEncryptType();
	/**
	 * 对报文进行加密加签
	 * 
	 * @param param
	 * @return 解密后的报文
	 * @throws Exception
	 */
	String encryptAndSign(Map<String, Object> param) throws SDKException;

	/**
	 * 对报文进行解密验签
	 * 
	 * @param pack
	 * @return 加密后的报文对象
	 * @throws Exception
	 */
	Map<String, Object> decryptAndSignCheck(String pack) throws SDKException;
	
	/**
	 * 返回加密后的对称密钥
	 * @return
	 */
	String getKey()throws SDKException;
	
	/**
	 * 返回加密后的校验和
	 * @return
	 */
	 String getChkStr()throws SDKException;
	 
	 /**
	  * 获取SM2加密后的IV向量
	  * @return
	  */
	 String getIV()throws SDKException;
	 
	 /**
	  * 返回未加密的对称密钥字节数组
	  * @return
	  */
	 byte[] getUnEncryptKey()throws SDKException;
	 

}