package com.zbank.file.secure;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.zbank.file.bean.SecureConfig;
import com.zbank.file.common.utils.JsonUtil;
import com.zbank.file.common.utils.SM2Util;
import com.zbank.file.exception.SDKException;

/**
 * @author daiwj
 * @date 2021/05/13
 * @description: SM2方式加解密
 */
public class SM2PackSecure extends AbstractPackScure{
    private static final Logger log = LoggerFactory.getLogger(SM2PackSecure.class);

    private SecureConfig secureConfig;

    public SM2PackSecure(SecureConfig secureConfig) {
        this.secureConfig = secureConfig;
    }

    @Override
    public String getEncryptType() {
        return "SM2";
    }

    @Override
    public String encryptAndSign(Map<String, Object> param) throws SDKException {
        try {
            String json = JsonUtil.MAPPER.writeValueAsString(param);
            log.info("加密前报文：{}", json);
            String encrypt = SM2Util.encrypt(json, secureConfig.getServerPubKey());
            log.info("加密后报文：{}", encrypt);
            return encrypt;
        } catch (Exception e) {
            log.error("报文加密加签异常", e);
            throw new SDKException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Map<String, Object> decryptAndSignCheck(String pack) throws SDKException {
        log.info("解密前报文：{}", pack);
        try {
            String decrypt = SM2Util.decrypt(pack, secureConfig.getPriKey());
            log.info("解密后报文：{}", decrypt);
            return JsonUtil.MAPPER.readValue(decrypt, HashMap.class);
        } catch (Exception e) {
            log.error("SM2解密异常", e);
            throw new SDKException(e.getMessage(), e.getCause());
        }
    }

    public SecureConfig getSecureConfig() {
        return secureConfig;
    }

    public SM2PackSecure setSecureConfig(SecureConfig secureConfig) {
        this.secureConfig = secureConfig;
        return this;
    }
}
