/*
 * Decompiled with CFR 0.152.
 */
package com.yuandong.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.yuandong.openapi.IClient;
import com.yuandong.openapi.config.IClientConfig;
import com.yuandong.openapi.exceptions.FeClientException;
import com.yuandong.openapi.exceptions.FeServerException;
import com.yuandong.openapi.http.FormatType;
import com.yuandong.openapi.http.HttpClientConfig;
import com.yuandong.openapi.http.HttpClientFactory;
import com.yuandong.openapi.http.HttpRequest;
import com.yuandong.openapi.http.HttpResponse;
import com.yuandong.openapi.http.IHttpClient;
import com.yuandong.openapi.http.MethodType;
import com.yuandong.openapi.model.FeCommonPageRequest;
import com.yuandong.openapi.model.FeCommonResponse;
import com.yuandong.openapi.model.FeCryptoRequest;
import com.yuandong.openapi.model.FeCryptoResponse;
import com.yuandong.openapi.model.FeHeaderRequest;
import com.yuandong.openapi.model.FePageRequest;
import com.yuandong.openapi.model.FePageResponse;
import com.yuandong.openapi.model.FeRequest;
import com.yuandong.openapi.model.FeResponse;
import com.yuandong.openapi.util.FeOpenUtil;
import com.yuandong.openapi.util.SM2Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
implements IClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultClient.class);
    private DefaultClient instance;
    private IClientConfig clientConfig;
    private IHttpClient httpClient;
    private List<String> ignoreSerializedFields = Collections.singletonList("responseClass");

    public DefaultClient(IClientConfig clientConfig) {
        this.httpClient = HttpClientFactory.buildClient(new HttpClientConfig());
        this.clientConfig = clientConfig;
    }

    @Override
    public <T extends FeResponse> FeCommonResponse post(FeRequest<T> feRequest, FeHeaderRequest feHeaderRequest) throws FeClientException, FeServerException, IOException {
        log.info("send fe request, requestId:{}, body:{}, header:{}", new Object[]{feHeaderRequest.getRequestId(), FeOpenUtil.getLog(feRequest, feHeaderRequest), JSON.toJSONString((Object)feHeaderRequest)});
        FeCryptoRequest crypto = this.encrypt(feRequest, feHeaderRequest);
        log.info("send fe crypto request, requestId:{}, body:{}", (Object)feHeaderRequest.getRequestId(), (Object)FeOpenUtil.getLog(feRequest, feHeaderRequest));
        FeCommonResponse<FeCryptoResponse> responseCrypto = this.doPost(crypto, feHeaderRequest);
        log.info("receive fe crypto response, requestId:{}, response:{}", (Object)feHeaderRequest.getRequestId(), (Object)JSON.toJSONString(responseCrypto));
        if (!FeCommonResponse.judgeIsSuccess(responseCrypto)) {
            throw new FeServerException(String.format("fe server error, requestId:%s, code:%s, message:%s", feHeaderRequest.getRequestId(), responseCrypto.getCode(), responseCrypto.getMessage()));
        }
        boolean pageRequestFlag = feRequest instanceof FeCommonPageRequest;
        return this.decrypt(responseCrypto, feRequest.getResponseClass(), feHeaderRequest.getRequestId(), pageRequestFlag);
    }

    @Override
    public <T extends FeResponse> FeCommonResponse<FePageResponse<T>> page(FeCommonPageRequest<FePageRequest<T>> feRequest, FeHeaderRequest feHeaderRequest) throws FeClientException, FeServerException, IOException {
        return this.post(feRequest, feHeaderRequest);
    }

    private <T extends FeResponse> FeCommonResponse<FePageResponse<T>> doPage(FeCommonPageRequest<FePageRequest<T>> feRequest, FeHeaderRequest feHeaderRequest) throws FeClientException, FeServerException, IOException {
        HttpRequest httpRequest = this.assemblyJsonRequest(feRequest);
        this.addFeHeaderRequest(httpRequest, feHeaderRequest);
        HttpResponse httpResponse = this.httpClient.syncInvoke(httpRequest);
        return this.parsePageResponse(feRequest, httpResponse);
    }

    private <T extends FeResponse> FeCommonResponse<T> doPost(FeRequest<T> feRequest, FeHeaderRequest feHeaderRequest) throws FeClientException, FeServerException, IOException {
        HttpRequest httpRequest = this.assemblyJsonRequest(feRequest);
        this.addFeHeaderRequest(httpRequest, feHeaderRequest);
        HttpResponse httpResponse = this.httpClient.syncInvoke(httpRequest);
        return this.parseCommonResponse(feRequest, httpResponse);
    }

    @Override
    public <T extends FeResponse> FeCommonResponse<T> upload(FeRequest<T> feRequest, FeHeaderRequest feHeaderRequest) throws FeClientException, FeServerException, IOException {
        feHeaderRequest.setUploadFlag(true);
        return this.post(feRequest, feHeaderRequest);
    }

    private <T extends FeResponse> FeCommonResponse<T> decrypt(FeCommonResponse<FeCryptoResponse> responseCrypto, Class<T> responseClass, String requestId, boolean pageRequestFlag) {
        FeCryptoResponse feCryptoResponse = responseCrypto.getValue();
        boolean verify = SM2Utils.verify(feCryptoResponse.getCipherBody(), feCryptoResponse.getSign(), this.clientConfig.getPuHuiSm2());
        if (!verify) {
            log.info("verify fail, requestId:{}", (Object)requestId);
            throw new FeClientException("Signature.Error", "verify fail");
        }
        String res = SM2Utils.decrypt(feCryptoResponse.getCipherBody(), this.clientConfig.getSelfSm2());
        log.info("fe decrypt response, requestId:{}, body:{}", (Object)requestId, (Object)res);
        FeCommonResponse feCommonResponse = (FeCommonResponse)JSON.parseObject((String)res, FeCommonResponse.class);
        JSONObject responseJsonObject = JSON.parseObject((String)res);
        this.parseData(responseClass, pageRequestFlag, feCommonResponse, responseJsonObject);
        log.info("fe response, requestId:{}, body:{}", (Object)requestId, (Object)JSON.toJSONString((Object)feCommonResponse));
        if (!FeCommonResponse.judgeIsSuccess(feCommonResponse)) {
            log.warn("fe response fail, requestId:{}, traceId:{}", (Object)requestId, (Object)responseCrypto.getTraceId());
        }
        return feCommonResponse;
    }

    private <T extends FeResponse> void parseData(Class<T> responseClass, boolean pageRequestFlag, FeCommonResponse feCommonResponse, JSONObject responseJsonObject) {
        Object value = responseJsonObject.get((Object)"value");
        if (value == null) {
            return;
        }
        if (pageRequestFlag) {
            this.parsePageData(responseClass, feCommonResponse, (JSONObject)value);
            return;
        }
        if (value instanceof JSONObject) {
            FeResponse data = (FeResponse)JSON.toJavaObject((JSON)((JSONObject)value), responseClass);
            feCommonResponse.setValue(data);
            return;
        }
        if (value instanceof JSONArray) {
            List dataList = ((JSONArray)value).toJavaList(responseClass);
            feCommonResponse.setValue(dataList);
            return;
        }
        throw new FeClientException("Value.Parse.Error", "error value type!");
    }

    private <T extends FeResponse> void parsePageData(Class<T> responseClass, FeCommonResponse feCommonResponse, JSONObject value) {
        FePageResponse data = (FePageResponse)JSON.toJavaObject((JSON)value, FePageResponse.class);
        feCommonResponse.setValue(data);
        JSONArray valueList = (JSONArray)value.get((Object)"valueList");
        if (valueList != null) {
            String js = JSONObject.toJSONString((Object)valueList);
            data.setValueList(JSONObject.parseArray((String)js, responseClass));
        }
    }

    private FeCryptoRequest encrypt(FeRequest feRequest, FeHeaderRequest feHeaderRequest) {
        FeCryptoRequest feCryptoRequest = new FeCryptoRequest();
        String encrypt = SM2Utils.encrypt(this.toJson(feRequest), this.clientConfig.getPuHuiSm2());
        String sign = SM2Utils.sign(encrypt + "&" + feHeaderRequest.getAppKey() + "&" + feHeaderRequest.getApiCode() + "&" + feHeaderRequest.getRequestId(), this.clientConfig.getSelfSm2());
        feCryptoRequest.setCipherBody(encrypt);
        feCryptoRequest.setSign(sign);
        log.info("fe crypto request, requestId:{}, encrypt:{}, sign:{}", new Object[]{feHeaderRequest.getRequestId(), FeOpenUtil.getLog(encrypt, feHeaderRequest.isUploadFlag()), sign});
        return feCryptoRequest;
    }

    private void addFeHeaderRequest(HttpRequest httpRequest, FeHeaderRequest feHeaderRequest) {
        httpRequest.putHeaderParameter("App-Key", feHeaderRequest.getAppKey());
        httpRequest.putHeaderParameter("Api-Code", feHeaderRequest.getApiCode());
        httpRequest.putHeaderParameter("Request-Id", feHeaderRequest.getRequestId());
        httpRequest.putHeaderParameter("Timestamp", feHeaderRequest.getTimestamp());
        httpRequest.putHeaderParameter("Version", feHeaderRequest.getVersion());
        httpRequest.putHeaderParameter("Sign-Method", feHeaderRequest.getSignMethod());
        httpRequest.putHeaderParameter("Grant-Type", feHeaderRequest.getGrantType());
        httpRequest.putHeaderParameter("Upload-Flag", String.valueOf(feHeaderRequest.isUploadFlag()));
    }

    private <T extends FeResponse> FeCommonResponse<T> parseCommonResponse(FeRequest<T> feRequest, HttpResponse httpResponse) {
        log.info("fe response, status:{}, reasonPhrase:{}", (Object)httpResponse.getStatus(), (Object)httpResponse.getReasonPhrase());
        byte[] httpContent = httpResponse.getHttpContent();
        String body = new String(httpContent, StandardCharsets.UTF_8);
        log.info("fe response, body:{}", (Object)FeOpenUtil.getLog(body, false));
        if (httpResponse.getStatus() != 200) {
            throw new FeServerException("fe server error, reasonPhrase:" + httpResponse.getReasonPhrase() + ",body:" + body);
        }
        FeCommonResponse feCommonResponse = (FeCommonResponse)JSON.parseObject((String)body, FeCommonResponse.class);
        JSONObject jsonObject = JSON.parseObject((String)body);
        Object value = jsonObject.get((Object)"value");
        if (value != null) {
            JSONObject valueObject = (JSONObject)value;
            feCommonResponse.setValue(valueObject.toJavaObject(feRequest.getResponseClass()));
        }
        return feCommonResponse;
    }

    private <T extends FeResponse> FeCommonResponse<FePageResponse<T>> parsePageResponse(FeCommonPageRequest<FePageRequest<T>> feRequest, HttpResponse httpResponse) {
        byte[] httpContent = httpResponse.getHttpContent();
        String body = new String(httpContent, StandardCharsets.UTF_8);
        FeCommonResponse feCommonResponse = (FeCommonResponse)JSON.parseObject((String)body, FeCommonResponse.class);
        JSONObject jsonObject = JSON.parseObject((String)body);
        Object value = jsonObject.get((Object)"value");
        if (value == null) {
            return feCommonResponse;
        }
        JSONObject valueObject = (JSONObject)value;
        feCommonResponse.setValue(valueObject.toJavaObject(FePageResponse.class));
        Object valueList = valueObject.get((Object)"valueList");
        if (valueList != null) {
            JSONArray valueArray = (JSONArray)valueList;
            FePageResponse fePageResponse = (FePageResponse)feCommonResponse.getValue();
            fePageResponse.setValueList(valueArray.toJavaList(feRequest.getResponseClass()));
        }
        return feCommonResponse;
    }

    private HttpRequest assemblyJsonRequest(FeRequest feRequest) {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setSysUrl(this.clientConfig.getUrl());
        httpRequest.setSysMethod(MethodType.POST);
        httpRequest.putHeaderParameter("Sdk-Version", "1.2.3");
        httpRequest.setHttpContent(JSON.toJSONString((Object)feRequest, (SerializeFilter)((PropertyFilter)(object, name, value) -> !this.ignoreSerializedFields.contains(name)), (SerializerFeature[])new SerializerFeature[0]).getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8.name(), FormatType.JSON);
        return httpRequest;
    }

    private String toJson(FeRequest feRequest) {
        return JSON.toJSONString((Object)feRequest, (SerializeFilter)((PropertyFilter)(object, name, value) -> !this.ignoreSerializedFields.contains(name)), (SerializerFeature[])new SerializerFeature[0]);
    }
}

