/*
 * Decompiled with CFR 0.152.
 */
package com.yuandong.openapi.config;

import cn.hutool.crypto.asymmetric.SM2;
import com.yuandong.openapi.config.IClientConfig;
import com.yuandong.openapi.util.SM2Utils;

public class DefaultClientConfig
implements IClientConfig {
    private SM2 selfSm2;
    private SM2 puHuiSm2;
    private String url;
    private String selfPrivateKey;
    private String selfPublicKey;
    private String fePublicKey;

    public DefaultClientConfig(String url, String selfPrivateKey, String selfPublicKey, String fePublicKey) {
        this.url = url;
        this.selfPrivateKey = selfPrivateKey;
        this.selfPublicKey = selfPublicKey;
        this.fePublicKey = fePublicKey;
        this.selfSm2 = SM2Utils.sm2Instance(selfPublicKey, selfPrivateKey);
        this.puHuiSm2 = SM2Utils.sm2Instance(fePublicKey, null);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public SM2 getSelfSm2() {
        return this.selfSm2;
    }

    @Override
    public SM2 getPuHuiSm2() {
        return this.puHuiSm2;
    }

    public String getSelfPrivateKey() {
        return this.selfPrivateKey;
    }

    public String getSelfPublicKey() {
        return this.selfPublicKey;
    }

    public String getFePublicKey() {
        return this.fePublicKey;
    }
}

