/*
 * Decompiled with CFR 0.152.
 */
package com.yuandong.openapi.http;

import cn.hutool.core.util.StrUtil;
import com.yuandong.openapi.exceptions.FeClientException;
import com.yuandong.openapi.http.FormatType;
import com.yuandong.openapi.http.HttpClientConfig;
import com.yuandong.openapi.http.HttpRequest;
import com.yuandong.openapi.http.HttpResponse;
import com.yuandong.openapi.http.IHttpClient;
import com.yuandong.openapi.http.RequestBuilder;
import com.yuandong.openapi.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient
extends IHttpClient {
    private static CloseableHttpClient httpClient;
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private PoolingHttpClientConnectionManager connectionManager;
    private CountDownLatch latch = new CountDownLatch(1);
    private static volatile ApacheHttpClient instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApacheHttpClient getInstance() {
        if (instance != null) return instance;
        Class<ApacheHttpClient> clazz = ApacheHttpClient.class;
        synchronized (ApacheHttpClient.class) {
            if (instance != null) return instance;
            instance = new ApacheHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ApacheHttpClient() {
    }

    @Override
    public void close() {
        instance = null;
        if (this.initialized.compareAndSet(true, false)) {
            this.connectionManager.shutdown();
            IOUtils.closeQuietly((Closeable)httpClient);
        }
    }

    @Override
    protected void init(HttpClientConfig clientConfig) throws FeClientException {
        if (!this.initialized.compareAndSet(false, true)) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new FeClientException("SDK.InitFailed", "Init apacheHttpClient failed", e);
            }
            return;
        }
        this.clientConfig = clientConfig;
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout(clientConfig.getConnectionTimeoutMillis()).setSocketTimeout(clientConfig.getReadTimeoutMillis()).setConnectionRequestTimeout(clientConfig.getWriteTimeoutMillis()).build();
        builder.setDefaultRequestConfig(defaultConfig);
        this.initConnectionManager();
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        if (clientConfig.getKeepAliveDurationMillis() > 0L) {
            builder.setKeepAliveStrategy((response, context) -> {
                long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                if (duration > 0L && duration < clientConfig.getKeepAliveDurationMillis()) {
                    return duration;
                }
                return clientConfig.getKeepAliveDurationMillis();
            });
        }
        httpClient = builder.build();
        this.latch.countDown();
    }

    private void initConnectionManager() throws FeClientException {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create();
        socketFactoryRegistryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        SSLConnectionSocketFactory sslConnectionSocketFactory = this.createSSLConnectionSocketFactory();
        socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
        this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        this.connectionManager.setMaxTotal(this.clientConfig.getMaxRequests());
        this.connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxRequestsPerHost());
    }

    private SSLConnectionSocketFactory createSSLConnectionSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        return sslsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse syncInvoke(HttpRequest apiRequest) throws IOException, FeClientException {
        HttpUriRequest httpRequest = this.convertToHttpRequest(apiRequest);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute(httpRequest);
            HttpResponse httpResponse2 = this.parseToHttpResponse(httpResponse);
            return httpResponse2;
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpResponse);
        }
    }

    private HttpResponse parseToHttpResponse(CloseableHttpResponse httpResponse) throws IOException {
        boolean existed;
        HttpResponse result = new HttpResponse();
        result.setStatus(httpResponse.getStatusLine().getStatusCode());
        result.setReasonPhrase(httpResponse.getStatusLine().getReasonPhrase());
        boolean bl = existed = httpResponse.getEntity() != null && (httpResponse.getEntity().getContentLength() > 0L || httpResponse.getEntity().isChunked());
        if (existed) {
            Header contentTypeHeader = httpResponse.getEntity().getContentType();
            if (null == contentTypeHeader) {
                throw new RuntimeException("contentType cannot be empty");
            }
            ContentType contentType = ContentType.parse((String)contentTypeHeader.getValue());
            FormatType formatType = FormatType.mapAcceptToFormat(contentType.getMimeType());
            result.setHttpContentType(formatType);
            String charset = "utf-8";
            if (contentType.getCharset() != null) {
                charset = contentType.getCharset().toString();
            }
            result.setHttpContent(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()), charset, formatType);
        }
        for (Header header : httpResponse.getAllHeaders()) {
            result.putHeaderParameter(header.getName(), header.getValue());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private HttpUriRequest convertToHttpRequest(HttpRequest apiRequest) {
        void var4_12;
        RequestBuilder builder = RequestBuilder.create(apiRequest.getSysMethod().name());
        builder.setUri(apiRequest.getSysUrl());
        if (apiRequest.getSysMethod().hasContent() && apiRequest.getHttpContent() != null && apiRequest.getHttpContent().length > 0) {
            void var4_7;
            EntityBuilder bodyBuilder = EntityBuilder.create();
            String string = apiRequest.getHeaderValue(CONTENT_TYPE);
            if (StrUtil.isEmpty((CharSequence)string)) {
                String string2 = apiRequest.getContentTypeValue(apiRequest.getHttpContentType(), apiRequest.getSysEncoding());
            }
            bodyBuilder.setContentType(ContentType.parse((String)var4_7));
            bodyBuilder.setBinary(apiRequest.getHttpContent());
            builder.setEntity(bodyBuilder.build());
        }
        builder.addHeader(ACCEPT_ENCODING, "identity");
        for (Map.Entry entry : apiRequest.getSysHeaders().entrySet()) {
            if ("Content-Length".equalsIgnoreCase((String)entry.getKey())) continue;
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        int connectTimeout = null != apiRequest.getSysConnectTimeout() ? apiRequest.getSysConnectTimeout().intValue() : this.clientConfig.getConnectionTimeoutMillis();
        if (null != apiRequest.getSysReadTimeout()) {
            int n = apiRequest.getSysReadTimeout();
        } else {
            int n = this.clientConfig.getReadTimeoutMillis();
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout((int)var4_12).setConnectionRequestTimeout(this.clientConfig.getWriteTimeoutMillis()).build();
        builder.setConfig(requestConfig);
        return builder.build();
    }
}

