/*
 * Decompiled with CFR 0.152.
 */
package com.yuandong.openapi.http;

import com.yuandong.openapi.exceptions.FeClientException;
import com.yuandong.openapi.http.FormatType;
import com.yuandong.openapi.http.MethodType;
import com.yuandong.openapi.util.Md5Util;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HttpMessage {
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_MD5 = "Content-MD5";
    protected static final String CONTENT_LENGTH = "Content-Length";
    protected String encoding = null;
    protected Integer connectTimeout = null;
    protected Integer readTimeout = null;
    private String url = null;
    protected Map<String, String> headers = new HashMap<String, String>();
    private MethodType method = null;
    protected FormatType httpContentType = null;
    protected byte[] httpContent = null;

    public HttpMessage(String strUrl) {
        this.url = strUrl;
    }

    public HttpMessage() {
    }

    public FormatType getHttpContentType() {
        return this.httpContentType;
    }

    public void setHttpContentType(FormatType httpContentType) {
        this.httpContentType = httpContentType;
        if (null != this.httpContent || null != httpContentType) {
            this.headers.put(CONTENT_TYPE, this.getContentTypeValue(this.httpContentType, this.encoding));
        } else {
            this.headers.remove(CONTENT_TYPE);
        }
    }

    public byte[] getHttpContent() {
        return this.httpContent;
    }

    public void setHttpContent(byte[] content, String encoding, FormatType format) {
        if (null == content) {
            this.headers.remove(CONTENT_TYPE);
            this.httpContentType = null;
            this.httpContent = null;
            this.encoding = null;
            return;
        }
        if (this.getSysMethod() != null && !this.getSysMethod().hasContent()) {
            content = new byte[]{};
        }
        this.httpContent = content;
        this.encoding = encoding;
        String contentLen = String.valueOf(content.length);
        String strMd5 = Md5Util.md5Sum(content);
        this.headers.put(CONTENT_MD5, strMd5);
        this.headers.put(CONTENT_LENGTH, contentLen);
        if (null != format) {
            this.headers.put(CONTENT_TYPE, FormatType.mapFormatToAccept(format));
        }
    }

    public void putHeaderParameter(String name, String value) {
        if (null != name && null != value) {
            this.headers.put(name, value);
        }
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public String getContentTypeValue(FormatType contentType, String encoding) {
        if (null != contentType && null != encoding) {
            return FormatType.mapFormatToAccept(contentType) + ";charset=" + encoding.toLowerCase();
        }
        if (null != contentType) {
            return FormatType.mapFormatToAccept(contentType);
        }
        return null;
    }

    public String getHttpContentString() throws FeClientException {
        String stringContent = "";
        if (this.httpContent != null) {
            try {
                stringContent = this.encoding == null ? new String(this.httpContent) : new String(this.httpContent, this.encoding);
            }
            catch (UnsupportedEncodingException exp) {
                throw new FeClientException("SDK.UnsupportedEncoding", "Can not parse response due to unsupported encoding.");
            }
        }
        return stringContent;
    }

    public String getSysUrl() {
        return this.url;
    }

    public void setSysUrl(String url) {
        this.url = url;
    }

    public MethodType getSysMethod() {
        return this.method;
    }

    public void setSysMethod(MethodType method) {
        this.method = method;
    }

    public String getSysEncoding() {
        return this.encoding;
    }

    public void setSysEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Integer getSysConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSysConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSysReadTimeout() {
        return this.readTimeout;
    }

    public void setSysReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Map<String, String> getSysHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getSysStrToSign() {
        return null;
    }
}

