/*
 * Decompiled with CFR 0.152.
 */
package com.yuandong.openapi.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;

public class SM2Utils {
    public static SM2 sm2Instance(String publicKey, String privateKey) {
        return SmUtil.sm2((byte[])Base64.decode((CharSequence)privateKey), (byte[])Base64.decode((CharSequence)publicKey));
    }

    public static String encrypt(String data, SM2 sm2) {
        return sm2.encryptBcd(data, KeyType.PublicKey);
    }

    public static String decrypt(String data, SM2 sm2) {
        return StrUtil.utf8Str((Object)sm2.decryptFromBcd(data, KeyType.PrivateKey));
    }

    public static String sign(String data, SM2 sm2) {
        return sm2.signHex(HexUtil.encodeHexStr((String)data));
    }

    public static boolean verify(String data, String sign, SM2 sm2) {
        return sm2.verifyHex(HexUtil.encodeHexStr((String)data), sign);
    }
}

