/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import fish.payara.arquillian.container.payara.NoOpLock;
import fish.payara.arquillian.container.payara.clientutils.PayaraClient;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientException;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientService;
import fish.payara.arquillian.jersey.media.multipart.FormDataMultiPart;
import fish.payara.arquillian.jersey.media.multipart.file.StreamDataBodyPart;
import fish.payara.arquillian.jersey.server.ContainerException;
import fish.payara.arquillian.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class CommonPayaraManager<C extends CommonPayaraConfiguration> {
    private static final Logger log = Logger.getLogger(CommonPayaraManager.class.getName());
    private static final String DELETE_OPERATION = "__deleteoperation";
    private static final Lock deployLock;
    private static final boolean prependDeploySequence;
    private final C configuration;
    private final PayaraClient payaraClient;
    private static final AtomicInteger deploySequence;

    public CommonPayaraManager(C configuration) {
        this.configuration = configuration;
        this.payaraClient = new PayaraClientService((CommonPayaraConfiguration)configuration);
    }

    public void start() throws LifecycleException {
        try {
            this.payaraClient.startUp();
        }
        catch (PayaraClientException e) {
            log.severe(e.getMessage());
            throw new LifecycleException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must not be null");
        }
        String archiveName = archive.getName();
        String deploymentName = this.createDeploymentName(prependDeploySequence ? String.format("r%d-%s", deploySequence.incrementAndGet(), archiveName) : archiveName);
        log.log(Level.FINE, "Deploying {0}", new Object[]{deploymentName});
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        try (InputStream deployment = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();){
            HTTPContext httpContext;
            FormDataMultiPart form = new FormDataMultiPart();
            form.bodyPart(new StreamDataBodyPart("id", deployment, archiveName));
            this.addDeployFormFields(deploymentName, form);
            deployLock.lock();
            try {
                httpContext = this.payaraClient.doDeploy(this.createDeploymentName(archiveName), form);
            }
            finally {
                deployLock.unlock();
            }
            protocolMetaData.addContext((Object)httpContext);
        }
        catch (PayaraClientException | IOException e) {
            throw new DeploymentException("Could not deploy " + archiveName, (Throwable)e);
        }
        catch (ContainerException containerException) {
            if (containerException.getMessage().contains("javax.enterprise.inject.spi.DeploymentException: Deployment Failure for")) {
                throw new javax.enterprise.inject.spi.DeploymentException((Throwable)containerException);
            }
            if (containerException.getMessage().contains("org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException: Method")) {
                throw new FaultToleranceDefinitionException((Throwable)containerException);
            }
            throw containerException;
        }
        return protocolMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must not be null");
        }
        String deploymentName = this.createDeploymentName(archive.getName());
        try {
            FormDataMultiPart form = new FormDataMultiPart();
            form.field("target", ((CommonPayaraConfiguration)this.configuration).getTarget(), MediaType.TEXT_PLAIN_TYPE);
            form.field("operation", DELETE_OPERATION, MediaType.TEXT_PLAIN_TYPE);
            deployLock.lock();
            try {
                this.payaraClient.doUndeploy(deploymentName, form);
            }
            finally {
                deployLock.unlock();
            }
        }
        catch (PayaraClientException e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public boolean isDASRunning() {
        return this.payaraClient.isDASRunning();
    }

    private String createDeploymentName(String archiveName) {
        String correctedName = archiveName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.contains(".")) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    private void addDeployFormFields(String name, FormDataMultiPart deployform) {
        deployform.field("name", name, MediaType.TEXT_PLAIN_TYPE);
        deployform.field("target", ((CommonPayaraConfiguration)this.configuration).getTarget(), MediaType.TEXT_PLAIN_TYPE);
        if (((CommonPayaraConfiguration)this.configuration).getLibraries() != null) {
            deployform.field("libraries", ((CommonPayaraConfiguration)this.configuration).getLibraries(), MediaType.TEXT_PLAIN_TYPE);
        }
        if (((CommonPayaraConfiguration)this.configuration).getProperties() != null) {
            deployform.field("properties", ((CommonPayaraConfiguration)this.configuration).getProperties(), MediaType.TEXT_PLAIN_TYPE);
        }
        if (((CommonPayaraConfiguration)this.configuration).getType() != null && "osgi".equals(((CommonPayaraConfiguration)this.configuration).getType())) {
            deployform.field("type", ((CommonPayaraConfiguration)this.configuration).getType(), MediaType.TEXT_PLAIN_TYPE);
        }
    }

    static {
        deploySequence = new AtomicInteger();
        prependDeploySequence = Boolean.getBoolean("fish.payara.arquillian.prependDeploySequence");
        Lock lock = deployLock = Boolean.getBoolean("fish.payara.arquillian.deployLock") ? new ReentrantLock() : new NoOpLock();
        if (deployLock instanceof ReentrantLock) {
            log.info("Serializing Deployments and Undeployments (fish.payara.arquillian.deployLock)");
        }
    }
}

