/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.faster.jackson.module.jaxb.ser;

import fish.payara.arquillian.faster.jackson.core.JsonGenerator;
import fish.payara.arquillian.faster.jackson.core.JsonProcessingException;
import fish.payara.arquillian.faster.jackson.databind.JavaType;
import fish.payara.arquillian.faster.jackson.databind.JsonMappingException;
import fish.payara.arquillian.faster.jackson.databind.JsonNode;
import fish.payara.arquillian.faster.jackson.databind.SerializerProvider;
import fish.payara.arquillian.faster.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import fish.payara.arquillian.faster.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import fish.payara.arquillian.faster.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import fish.payara.arquillian.faster.jackson.databind.node.ObjectNode;
import fish.payara.arquillian.faster.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.activation.DataHandler;

public class DataHandlerJsonSerializer
extends StdSerializer<DataHandler> {
    private static final long serialVersionUID = 1L;

    public DataHandlerJsonSerializer() {
        super(DataHandler.class);
    }

    @Override
    public void serialize(DataHandler value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        InputStream in = value.getInputStream();
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        jgen.writeBinary(out.toByteArray());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.STRING);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("string");
        o.set("items", itemSchema);
        return o;
    }
}

