/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.jaxb.internal;

import fish.payara.arquillian.inject.Inject;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.jaxb.internal.AbstractXmlFactory;
import fish.payara.arquillian.jersey.jaxb.internal.JaxbFeatureUtil;
import fish.payara.arquillian.jersey.jaxb.internal.LocalizationMessages;
import fish.payara.arquillian.ws.rs.core.Configuration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class TransformerFactoryInjectionProvider
extends AbstractXmlFactory<TransformerFactory> {
    private static final Logger LOGGER = Logger.getLogger(TransformerFactoryInjectionProvider.class.getName());
    @Inject
    private InjectionManager injectionManager;

    @Inject
    public TransformerFactoryInjectionProvider(Configuration config) {
        super(config);
    }

    @Override
    public TransformerFactory get() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!this.isXmlSecurityDisabled()) {
            try {
                transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (TransformerConfigurationException e) {
                LOGGER.log(Level.CONFIG, LocalizationMessages.UNABLE_TO_SECURE_XML_TRANSFORMER_PROCESSING(), e);
            }
        }
        JaxbFeatureUtil.setFeatures(this.injectionManager, TransformerFactory.class, transformerFactory::setFeature);
        JaxbFeatureUtil.setProperties(this.injectionManager, TransformerFactory.class, transformerFactory::setAttribute);
        return transformerFactory;
    }
}

