/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server;

import fish.payara.arquillian.jersey.internal.BootstrapBag;
import fish.payara.arquillian.jersey.internal.BootstrapConfigurator;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.internal.inject.ProviderBinder;
import fish.payara.arquillian.jersey.internal.inject.Providers;
import fish.payara.arquillian.jersey.model.ContractProvider;
import fish.payara.arquillian.jersey.model.internal.ComponentBag;
import fish.payara.arquillian.jersey.server.ResourceBag;
import fish.payara.arquillian.jersey.server.ResourceConfig;
import fish.payara.arquillian.jersey.server.ServerBootstrapBag;
import fish.payara.arquillian.jersey.server.internal.JerseyResourceContext;
import fish.payara.arquillian.jersey.server.internal.LocalizationMessages;
import fish.payara.arquillian.jersey.server.model.ModelProcessor;
import fish.payara.arquillian.jersey.server.model.Resource;
import fish.payara.arquillian.jersey.server.model.ResourceModel;
import fish.payara.arquillian.jersey.server.spi.ComponentProvider;
import fish.payara.arquillian.ws.rs.RuntimeType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ResourceModelConfigurator
implements BootstrapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(ResourceModelConfigurator.class.getName());

    @Override
    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        Collection<ModelProcessor> modelProcessors = serverBag.getModelProcessors();
        ResourceConfig runtimeConfig = serverBag.getRuntimeConfig();
        ResourceBag resourceBag = serverBag.getResourceBag();
        ComponentBag componentBag = runtimeConfig.getComponentBag();
        this.bindProvidersAndResources(injectionManager, serverBag, componentBag, resourceBag.classes, resourceBag.instances, runtimeConfig);
        ResourceModel resourceModel = new ResourceModel.Builder(resourceBag.getRootResources(), false).build();
        resourceModel = this.processResourceModel(modelProcessors, resourceModel, runtimeConfig);
        this.bindEnhancingResourceClasses(injectionManager, serverBag, resourceModel, resourceBag, runtimeConfig);
        serverBag.setResourceModel(resourceModel);
        serverBag.getResourceContext().setResourceModel(resourceModel);
    }

    private ResourceModel processResourceModel(Collection<ModelProcessor> modelProcessors, ResourceModel resourceModel, ResourceConfig runtimeConfig) {
        for (ModelProcessor modelProcessor : modelProcessors) {
            resourceModel = modelProcessor.processResourceModel(resourceModel, runtimeConfig);
        }
        return resourceModel;
    }

    private void bindEnhancingResourceClasses(InjectionManager injectionManager, ServerBootstrapBag bootstrapBag, ResourceModel resourceModel, ResourceBag resourceBag, ResourceConfig runtimeConfig) {
        HashSet newClasses = new HashSet();
        HashSet<Object> newInstances = new HashSet<Object>();
        for (Resource res : resourceModel.getRootResources()) {
            newClasses.addAll(res.getHandlerClasses());
            newInstances.addAll(res.getHandlerInstances());
        }
        newClasses.removeAll(resourceBag.classes);
        newInstances.removeAll(resourceBag.instances);
        ComponentBag emptyComponentBag = ComponentBag.newInstance(input -> false);
        this.bindProvidersAndResources(injectionManager, bootstrapBag, emptyComponentBag, newClasses, newInstances, runtimeConfig);
    }

    private void bindProvidersAndResources(InjectionManager injectionManager, ServerBootstrapBag bootstrapBag, ComponentBag componentBag, Collection<Class<?>> resourceClasses, Collection<Object> resourceInstances, ResourceConfig runtimeConfig) {
        Collection componentProviders = (Collection)bootstrapBag.getComponentProviders().get();
        JerseyResourceContext resourceContext = bootstrapBag.getResourceContext();
        Set<Class<?>> registeredClasses = runtimeConfig.getRegisteredClasses();
        Predicate<Class> correctlyConfigured = componentClass -> Providers.checkProviderRuntime(componentClass, componentBag.getModel((Class<?>)componentClass), RuntimeType.SERVER, !registeredClasses.contains(componentClass), resourceClasses.contains(componentClass));
        BiPredicate<Class, ContractProvider> correctlyConfiguredResource = (resourceClass, model) -> Providers.checkProviderRuntime(resourceClass, model, RuntimeType.SERVER, !registeredClasses.contains(resourceClass), true);
        Set componentClasses = componentBag.getClasses(ComponentBag.excludeMetaProviders(injectionManager)).stream().filter(correctlyConfigured).collect(Collectors.toSet());
        Set<Class> classes = Collections.newSetFromMap(new IdentityHashMap());
        classes.addAll(componentClasses);
        classes.addAll(resourceClasses);
        for (Class componentClass2 : classes) {
            ContractProvider model2;
            if (this.bindWithComponentProvider(componentClass2, model2 = componentBag.getModel(componentClass2), componentProviders)) continue;
            if (resourceClasses.contains(componentClass2)) {
                if (!Resource.isAcceptable(componentClass2)) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_COMPONENT(componentClass2));
                    continue;
                }
                if (model2 != null && !correctlyConfiguredResource.test(componentClass2, model2)) {
                    model2 = null;
                }
                resourceContext.unsafeBindResource(componentClass2, model2);
                continue;
            }
            ProviderBinder.bindProvider(componentClass2, model2, injectionManager);
        }
        Set instances = componentBag.getInstances(ComponentBag.excludeMetaProviders(injectionManager)).stream().filter(instance -> correctlyConfigured.test(instance.getClass())).collect(Collectors.toSet());
        instances.addAll(resourceInstances);
        for (Object component : instances) {
            ContractProvider model3 = componentBag.getModel(component.getClass());
            if (resourceInstances.contains(component)) {
                if (model3 != null && !correctlyConfiguredResource.test(component.getClass(), model3)) {
                    model3 = null;
                }
                resourceContext.unsafeBindResource(component, model3);
                continue;
            }
            ProviderBinder.bindProvider(component, model3, injectionManager);
        }
    }

    private boolean bindWithComponentProvider(Class<?> component, ContractProvider providerModel, Iterable<ComponentProvider> componentProviders) {
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, providerModel)) continue;
            return true;
        }
        return false;
    }
}

