/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server;

import fish.payara.arquillian.jersey.internal.BootstrapBag;
import fish.payara.arquillian.jersey.internal.inject.Bindings;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.internal.inject.InstanceBinding;
import fish.payara.arquillian.jersey.model.internal.ComponentBag;
import fish.payara.arquillian.jersey.process.internal.AbstractExecutorProvidersConfigurator;
import fish.payara.arquillian.jersey.server.BackgroundScheduler;
import fish.payara.arquillian.jersey.server.BackgroundSchedulerLiteral;
import fish.payara.arquillian.jersey.server.ManagedAsyncExecutor;
import fish.payara.arquillian.jersey.server.ResourceConfig;
import fish.payara.arquillian.jersey.server.ServerBootstrapBag;
import fish.payara.arquillian.jersey.spi.ExecutorServiceProvider;
import fish.payara.arquillian.jersey.spi.ScheduledExecutorServiceProvider;
import fish.payara.arquillian.jersey.spi.ScheduledThreadPoolExecutorProvider;
import fish.payara.arquillian.jersey.spi.ThreadPoolExecutorProvider;

class ServerExecutorProvidersConfigurator
extends AbstractExecutorProvidersConfigurator {
    ServerExecutorProvidersConfigurator() {
    }

    @Override
    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        ResourceConfig runtimeConfig = serverBag.getRuntimeConfig();
        ComponentBag componentBag = runtimeConfig.getComponentBag();
        DefaultBackgroundSchedulerProvider defaultScheduledExecutorProvider = new DefaultBackgroundSchedulerProvider();
        InstanceBinding schedulerBinding = (InstanceBinding)((InstanceBinding)Bindings.service(defaultScheduledExecutorProvider).to(ScheduledExecutorServiceProvider.class)).qualifiedBy(BackgroundSchedulerLiteral.INSTANCE);
        injectionManager.register(schedulerBinding);
        DefaultManagedAsyncExecutorProvider defaultAsyncExecutorProvider = new DefaultManagedAsyncExecutorProvider();
        InstanceBinding executorBinding = (InstanceBinding)Bindings.service(defaultAsyncExecutorProvider).to(ExecutorServiceProvider.class);
        injectionManager.register(executorBinding);
        this.registerExecutors(injectionManager, componentBag, defaultAsyncExecutorProvider, defaultScheduledExecutorProvider, serverBag.getManagedObjectsFinalizer());
    }

    @ManagedAsyncExecutor
    private static class DefaultManagedAsyncExecutorProvider
    extends ThreadPoolExecutorProvider {
        public DefaultManagedAsyncExecutorProvider() {
            super("jersey-server-managed-async-executor");
        }
    }

    @BackgroundScheduler
    private static class DefaultBackgroundSchedulerProvider
    extends ScheduledThreadPoolExecutorProvider {
        public DefaultBackgroundSchedulerProvider() {
            super("jersey-background-task-scheduler");
        }

        @Override
        protected int getCorePoolSize() {
            return 1;
        }
    }
}

