/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.inject;

import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.ExtractorException;
import fish.payara.arquillian.jersey.model.Parameter;
import fish.payara.arquillian.jersey.server.ContainerRequest;
import fish.payara.arquillian.jersey.server.ParamException;
import fish.payara.arquillian.jersey.server.internal.inject.AbstractValueParamProvider;
import fish.payara.arquillian.jersey.server.internal.inject.MultivaluedParameterExtractor;
import fish.payara.arquillian.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import fish.payara.arquillian.jersey.server.model.Parameter;
import java.util.function.Function;

@Singleton
final class HeaderParamValueParamProvider
extends AbstractValueParamProvider {
    public HeaderParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, Parameter.Source.HEADER);
    }

    @Override
    public Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new HeaderParamValueProvider(e);
    }

    private static final class HeaderParamValueProvider
    implements Function<ContainerRequest, Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        HeaderParamValueProvider(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            try {
                return this.extractor.extract(containerRequest.getHeaders());
            }
            catch (ExtractorException e) {
                throw new ParamException.HeaderParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

