/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.inject;

import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.ExtractorException;
import fish.payara.arquillian.jersey.model.Parameter;
import fish.payara.arquillian.jersey.server.ContainerRequest;
import fish.payara.arquillian.jersey.server.ParamException;
import fish.payara.arquillian.jersey.server.internal.inject.AbstractValueParamProvider;
import fish.payara.arquillian.jersey.server.internal.inject.MultivaluedParameterExtractor;
import fish.payara.arquillian.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import fish.payara.arquillian.jersey.server.model.Parameter;
import fish.payara.arquillian.ws.rs.core.PathSegment;
import java.util.List;
import java.util.function.Function;

@Singleton
final class MatrixParamValueParamProvider
extends AbstractValueParamProvider {
    public MatrixParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, Parameter.Source.MATRIX);
    }

    @Override
    public Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new MatrixParamValueProvider(e, !parameter.isEncoded());
    }

    private static final class MatrixParamValueProvider
    implements Function<ContainerRequest, Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        MatrixParamValueProvider(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            List<PathSegment> l = containerRequest.getUriInfo().getPathSegments(this.decode);
            PathSegment p = l.get(l.size() - 1);
            try {
                return this.extractor.extract(p.getMatrixParameters());
            }
            catch (ExtractorException e) {
                throw new ParamException.MatrixParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

