/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.wadl;

import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.AbstractBinder;
import fish.payara.arquillian.jersey.internal.inject.ClassBinding;
import fish.payara.arquillian.jersey.internal.util.PropertiesHelper;
import fish.payara.arquillian.jersey.internal.util.ReflectionHelper;
import fish.payara.arquillian.jersey.server.internal.LocalizationMessages;
import fish.payara.arquillian.jersey.server.wadl.WadlApplicationContext;
import fish.payara.arquillian.jersey.server.wadl.internal.WadlApplicationContextImpl;
import fish.payara.arquillian.jersey.server.wadl.processor.WadlModelProcessor;
import fish.payara.arquillian.ws.rs.core.Feature;
import fish.payara.arquillian.ws.rs.core.FeatureContext;
import java.util.logging.Logger;

public class WadlFeature
implements Feature {
    private static final Logger LOGGER = Logger.getLogger(WadlFeature.class.getName());

    @Override
    public boolean configure(FeatureContext context) {
        boolean disabled = PropertiesHelper.isProperty(context.getConfiguration().getProperty("jersey.config.server.wadl.disableWadl"));
        if (disabled) {
            return false;
        }
        if (!ReflectionHelper.isJaxbAvailable()) {
            LOGGER.warning(LocalizationMessages.WADL_FEATURE_DISABLED_NOJAXB());
            return false;
        }
        if (!ReflectionHelper.isXmlTransformAvailable()) {
            LOGGER.warning(LocalizationMessages.WADL_FEATURE_DISABLED_NOTRANSFORM());
            return false;
        }
        if (!WadlApplicationContextImpl.isJaxbImplAvailable()) {
            LOGGER.warning(LocalizationMessages.WADL_FEATURE_DISABLED());
            return false;
        }
        context.register(WadlModelProcessor.class);
        context.register(new AbstractBinder(){

            @Override
            protected void configure() {
                ((ClassBinding)this.bind(WadlApplicationContextImpl.class).to(WadlApplicationContext.class)).in(Singleton.class);
            }
        });
        return true;
    }
}

