/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.wadl.processor;

import fish.payara.arquillian.annotation.Priority;
import fish.payara.arquillian.inject.Inject;
import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.jersey.process.Inflector;
import fish.payara.arquillian.jersey.server.ExtendedUriInfo;
import fish.payara.arquillian.jersey.server.model.ModelProcessor;
import fish.payara.arquillian.jersey.server.model.ResourceModel;
import fish.payara.arquillian.jersey.server.model.internal.ModelProcessorUtil;
import fish.payara.arquillian.ws.rs.container.ContainerRequestContext;
import fish.payara.arquillian.ws.rs.core.Configuration;
import fish.payara.arquillian.ws.rs.core.MediaType;
import fish.payara.arquillian.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Priority(value=0x7FFFFFFF)
public class OptionsMethodProcessor
implements ModelProcessor {
    private final List<ModelProcessorUtil.Method> methodList = new ArrayList<ModelProcessorUtil.Method>();

    public OptionsMethodProcessor() {
        this.methodList.add(new ModelProcessorUtil.Method("OPTIONS", MediaType.WILDCARD_TYPE, MediaType.TEXT_PLAIN_TYPE, PlainTextOptionsInflector.class));
        this.methodList.add(new ModelProcessorUtil.Method("OPTIONS", MediaType.WILDCARD_TYPE, MediaType.WILDCARD_TYPE, GenericOptionsInflector.class));
    }

    @Override
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return ModelProcessorUtil.enhanceResourceModel(resourceModel, false, this.methodList, true).build();
    }

    @Override
    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return ModelProcessorUtil.enhanceResourceModel(subResourceModel, true, this.methodList, true).build();
    }

    private static class GenericOptionsInflector
    implements Inflector<ContainerRequestContext, Response> {
        @Inject
        private Provider<ExtendedUriInfo> extendedUriInfo;

        private GenericOptionsInflector() {
        }

        @Override
        public Response apply(ContainerRequestContext containerRequestContext) {
            Set<String> allowedMethods = ModelProcessorUtil.getAllowedMethods(this.extendedUriInfo.get().getMatchedRuntimeResources().get(0));
            return Response.ok().allow(allowedMethods).header("Content-Length", "0").type(containerRequestContext.getAcceptableMediaTypes().get(0)).build();
        }
    }

    private static class PlainTextOptionsInflector
    implements Inflector<ContainerRequestContext, Response> {
        @Inject
        private Provider<ExtendedUriInfo> extendedUriInfo;

        private PlainTextOptionsInflector() {
        }

        @Override
        public Response apply(ContainerRequestContext containerRequestContext) {
            Set<String> allowedMethods = ModelProcessorUtil.getAllowedMethods(this.extendedUriInfo.get().getMatchedRuntimeResources().get(0));
            String allowedList = allowedMethods.toString();
            String optionsBody = allowedList.substring(1, allowedList.length() - 1);
            return Response.ok((Object)optionsBody, MediaType.TEXT_PLAIN_TYPE).allow(allowedMethods).build();
        }
    }
}

