/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.json.jaxrs;

import fish.payara.arquillian.javax.json.Json;
import fish.payara.arquillian.javax.json.JsonReader;
import fish.payara.arquillian.javax.json.JsonReaderFactory;
import fish.payara.arquillian.javax.json.JsonValue;
import fish.payara.arquillian.ws.rs.Consumes;
import fish.payara.arquillian.ws.rs.WebApplicationException;
import fish.payara.arquillian.ws.rs.core.MediaType;
import fish.payara.arquillian.ws.rs.core.MultivaluedMap;
import fish.payara.arquillian.ws.rs.ext.MessageBodyReader;
import fish.payara.arquillian.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
@Consumes(value={"application/json", "text/json", "*/*"})
public class JsonValueBodyReader
implements MessageBodyReader<JsonValue> {
    private final JsonReaderFactory rf = Json.createReaderFactory(null);
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonValue.class.isAssignableFrom(aClass) && JsonValueBodyReader.supportsMediaType(mediaType);
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    @Override
    public JsonValue readFrom(Class<JsonValue> jsonValueClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> stringStringMultivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        try (JsonReader reader = this.rf.createReader(inputStream);){
            JsonValue jsonValue = reader.readValue();
            return jsonValue;
        }
    }
}

