package global.hh.openapi.sdk.api.bean.corpbasic;

        import java.util.List;

/**
 * @description: 发送应用消息，类型：小程序通知消息
 * @author: 12869
 * @date: 2022-33-07 16:33:16
 */
public class CorpbasicNoticeReqBean {
    /**
     * 自建应用id
     */
    private String agentId;

    /**
     * 小程序appid，必须是与当前应用关联的小程序
     */
    private String appId;

    /**
     * 消息内容键值对，最多允许10个item
     */
    private List<CorpbasicNoticeContentItemItem> contentItems;

    /**
     * 消息描述，长度限制4-12个汉字（支持id转译）
     */
    private String description;

    /**
     * 是否放大第一个content_item
     */
    private Boolean emphasisFirstItem;

    /**
     * 点击消息卡片后的小程序页面，仅限本小程序内的页面。该字段不填则消息点击后不跳转。
     */
    private String page;

    /**
     * 消息标题，长度限制4-12个汉字（支持id转译）
     */
    private String title;

    /**
     * 部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数
     */
    private String toParty;

    /**
     * 成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送
     */
    private String toUser;

    public CorpbasicNoticeReqBean(){
    }

    public CorpbasicNoticeReqBean(String agentId,String appId,List<CorpbasicNoticeContentItemItem> contentItems,String description,Boolean emphasisFirstItem,String page,String title,String toParty,String toUser){
        this.agentId=agentId;
        this.appId=appId;
        this.contentItems=contentItems;
        this.description=description;
        this.emphasisFirstItem=emphasisFirstItem;
        this.page=page;
        this.title=title;
        this.toParty=toParty;
        this.toUser=toUser;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }
    public List<CorpbasicNoticeContentItemItem> getContentItems() {
        return contentItems;
    }

    public void setContentItems(List<CorpbasicNoticeContentItemItem> contentItems) {
        this.contentItems = contentItems;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public Boolean getEmphasisFirstItem() {
        return emphasisFirstItem;
    }

    public void setEmphasisFirstItem(Boolean emphasisFirstItem) {
        this.emphasisFirstItem = emphasisFirstItem;
    }
    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public String getToParty() {
        return toParty;
    }

    public void setToParty(String toParty) {
        this.toParty = toParty;
    }
    public String getToUser() {
        return toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }
}
