package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetJobListReqBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetJobListResBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceSavePromoterSigningTimeReqBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceSavePromoterSigningTimeResBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetUserListReqBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetUserListResBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetPostListReqBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetPostListResBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetListReqBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetListResBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetDepartmentListReqBean;
import global.hh.openapi.sdk.api.bean.accountservice.AccountserviceGetDepartmentListResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 获取HCM职务信息接口
 * @author: 23465
 * @date: 2023-56-15 15:56:26
 */
public class AccountServiceService extends BaseService {

    public AccountServiceService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 获取HCM职务信息接口
     *
     * @author 23465
     * @createDate 2023-56-15 15:56:26
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<AccountserviceGetJobListResBean> getJobList(BaseRequest<AccountserviceGetJobListReqBean> req) throws BaseException {
        return call("account-service/hcm/getJobList", req);
    }
    /**
    * 方法的功能描述: 获取HCM职务信息接口
    *
    * @author 23465
    * @createDate 2023-56-15 15:56:26
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<AccountserviceGetJobListResBean> getJobList(String url,BaseRequest<AccountserviceGetJobListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 保存品牌大使签约时间
     *
     * @author 13258
     * @createDate 2023-25-05 11:25:41
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<AccountserviceSavePromoterSigningTimeResBean> savePromoterSigningTime(BaseRequest<AccountserviceSavePromoterSigningTimeReqBean> req) throws BaseException {
        return call("account-service/personnel/savePromoterSigningTime", req);
    }
    /**
    * 方法的功能描述: 保存品牌大使签约时间
    *
    * @author 13258
    * @createDate 2023-25-05 11:25:41
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<AccountserviceSavePromoterSigningTimeResBean> savePromoterSigningTime(String url,BaseRequest<AccountserviceSavePromoterSigningTimeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取HCM用户信息
     *
     * @author 23465
     * @createDate 2023-20-06 11:20:16
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<AccountserviceGetUserListResBean> getUserList(BaseRequest<AccountserviceGetUserListReqBean> req) throws BaseException {
        return call("account-service/hcm/getUserList", req);
    }
    /**
    * 方法的功能描述: 获取HCM用户信息
    *
    * @author 23465
    * @createDate 2023-20-06 11:20:16
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<AccountserviceGetUserListResBean> getUserList(String url,BaseRequest<AccountserviceGetUserListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: HCM人员岗位接口
     *
     * @author 23465
     * @createDate 2023-12-10 14:12:06
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<AccountserviceGetPostListResBean> getPostList(BaseRequest<AccountserviceGetPostListReqBean> req) throws BaseException {
        return call("account-service/hcm/getPostList", req);
    }
    /**
    * 方法的功能描述: HCM人员岗位接口
    *
    * @author 23465
    * @createDate 2023-12-10 14:12:06
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<AccountserviceGetPostListResBean> getPostList(String url,BaseRequest<AccountserviceGetPostListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 人员与终端
     *
     * @author 23465
     * @createDate 2023-42-13 21:42:07
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<AccountserviceGetListResBean> getList(BaseRequest<AccountserviceGetListReqBean> req) throws BaseException {
        return call("account-service/personnelTerminal/getList", req);
    }
    /**
    * 方法的功能描述: 人员与终端
    *
    * @author 23465
    * @createDate 2023-42-13 21:42:07
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<AccountserviceGetListResBean> getList(String url,BaseRequest<AccountserviceGetListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: HCM组织架构
     *
     * @author 23465
     * @createDate 2023-32-28 16:32:01
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<AccountserviceGetDepartmentListResBean> getDepartmentList(BaseRequest<AccountserviceGetDepartmentListReqBean> req) throws BaseException {
        return call("account-service/hcm/getDepartmentList", req);
    }
    /**
    * 方法的功能描述: HCM组织架构
    *
    * @author 23465
    * @createDate 2023-32-28 16:32:01
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<AccountserviceGetDepartmentListResBean> getDepartmentList(String url,BaseRequest<AccountserviceGetDepartmentListReqBean> req) throws BaseException {
         return call(url, req);
    }


}
