package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.coupon.CouponLbxReqBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponLbxResBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponAbolishReqBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponAbolishResBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponSendReqBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponSendResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 第三方商家活动批量积分
 * @author: 12552
 * @date: 2019-14-28 16:14:28
 */
public class CouponService extends BaseService {

    public CouponService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 第三方商家活动批量积分
     *
     * @author 12552
     * @createDate 2019-14-28 16:14:28
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CouponLbxResBean> lbx(BaseRequest<CouponLbxReqBean> req) throws BaseException {
        return call("coupon-api/coupon/regActivity/lbx", req);
    }
    /**
    * 方法的功能描述: 第三方商家活动批量积分
    *
    * @author 12552
    * @createDate 2019-14-28 16:14:28
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CouponLbxResBean> lbx(String url,BaseRequest<CouponLbxReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 收回优惠券
     *
     * @author 12552
     * @createDate 2018-08-07 17:08:00
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CouponAbolishResBean> abolish(BaseRequest<CouponAbolishReqBean> req) throws BaseException {
        return call("coupon-api/coupon/abolish", req);
    }
    /**
    * 方法的功能描述: 收回优惠券
    *
    * @author 12552
    * @createDate 2018-08-07 17:08:00
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CouponAbolishResBean> abolish(String url,BaseRequest<CouponAbolishReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 领取/发送优惠券
     *
     * @author 12552
     * @createDate 2018-10-07 17:10:37
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CouponSendResBean> send(BaseRequest<CouponSendReqBean> req) throws BaseException {
        return call("coupon-api/coupon/send", req);
    }
    /**
    * 方法的功能描述: 领取/发送优惠券
    *
    * @author 12552
    * @createDate 2018-10-07 17:10:37
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CouponSendResBean> send(String url,BaseRequest<CouponSendReqBean> req) throws BaseException {
         return call(url, req);
    }


}
