package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.label.LabelBatchTaggingReqBean;
import global.hh.openapi.sdk.api.bean.label.LabelBatchTaggingResBean;
import global.hh.openapi.sdk.api.bean.label.LabelTaggingReqBean;
import global.hh.openapi.sdk.api.bean.label.LabelTaggingResBean;
import global.hh.openapi.sdk.api.bean.label.LabelTriggerReqBean;
import global.hh.openapi.sdk.api.bean.label.LabelTriggerResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 企微给批量会员手机号打标
 * @author: 12869
 * @date: 2021-21-11 17:21:49
 */
public class LabelService extends BaseService {

    public LabelService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 企微批量打标接口
     *
     * @author 12869
     * @createDate 2021-21-11 17:21:49
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<LabelBatchTaggingResBean> batchTagging(BaseRequest<LabelBatchTaggingReqBean> req) throws BaseException {
        return call("label-service/api/customer/batch/tagging", req);
    }
    /**
    * 方法的功能描述: 企微批量打标接口
    *
    * @author 12869
    * @createDate 2021-21-11 17:21:49
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<LabelBatchTaggingResBean> batchTagging(String url,BaseRequest<LabelBatchTaggingReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 给用户打标签。包括打标签和删除标签
     *
     * @author 12869
     * @createDate 2021-45-10 09:45:54
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<LabelTaggingResBean> tagging(BaseRequest<LabelTaggingReqBean> req) throws BaseException {
        return call("label-service/api/customer/tagging", req);
    }
    /**
    * 方法的功能描述: 给用户打标签。包括打标签和删除标签
    *
    * @author 12869
    * @createDate 2021-45-10 09:45:54
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<LabelTaggingResBean> tagging(String url,BaseRequest<LabelTaggingReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 触发同步会员标签(系统标签)
     *
     * @author 12869
     * @createDate 2021-56-16 13:56:18
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<LabelTriggerResBean> trigger(BaseRequest<LabelTriggerReqBean> req) throws BaseException {
        return call("label-service/api/customer/sync/trigger", req);
    }
    /**
    * 方法的功能描述: 触发同步会员标签(系统标签)
    *
    * @author 12869
    * @createDate 2021-56-16 13:56:18
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<LabelTriggerResBean> trigger(String url,BaseRequest<LabelTriggerReqBean> req) throws BaseException {
         return call(url, req);
    }


}
