package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.member.MemberQueryReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberQueryResBean;
import global.hh.openapi.sdk.api.bean.member.MemberQueryCardReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberQueryCardResBean;
import global.hh.openapi.sdk.api.bean.member.MemberVerifyApplyCardReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberVerifyApplyCardResBean;
import global.hh.openapi.sdk.api.bean.member.MemberVerifykNewCustomerReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberVerifykNewCustomerResBean;
import global.hh.openapi.sdk.api.bean.member.MemberIsWeComReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberIsWeComResBean;
import global.hh.openapi.sdk.api.bean.member.MemberSyncBbxNewCustomerReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberSyncBbxNewCustomerResBean;
import global.hh.openapi.sdk.api.bean.member.MemberRegistWsCustReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberRegistWsCustResBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckIsNewCilentReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckIsNewCilentResBean;
import global.hh.openapi.sdk.api.bean.member.MemberAddCustKidReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberAddCustKidResBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckMobileExistReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckMobileExistResBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckClientStatusReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckClientStatusResBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckCategoryClientReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckCategoryClientResBean;
import global.hh.openapi.sdk.api.bean.member.MemberUnionIdReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberUnionIdResBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckNewClientV2ReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckNewClientV2ResBean;
import global.hh.openapi.sdk.api.bean.member.MemberGetWsCustInfoReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberGetWsCustInfoResBean;
import global.hh.openapi.sdk.api.bean.member.MemberEditWsCustInfoReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberEditWsCustInfoResBean;
import global.hh.openapi.sdk.api.bean.member.MemberMama100ReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberMama100ResBean;
import global.hh.openapi.sdk.api.bean.member.MemberSyncCommonNewCustomerV2ReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberSyncCommonNewCustomerV2ResBean;
import global.hh.openapi.sdk.api.bean.member.MemberTaskFinishReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberTaskFinishResBean;
import global.hh.openapi.sdk.api.bean.member.MemberCallFinishReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCallFinishResBean;
import global.hh.openapi.sdk.api.bean.member.MemberChangeIntentionReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberChangeIntentionResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 查询会员信息，根据用户手机号
 * @author: 12869
 * @date: 2023-41-31 16:41:19
 */
public class MemberService extends BaseService {

    public MemberService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询会员信息
     *
     * @author 12869
     * @createDate 2023-41-31 16:41:19
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberQueryResBean> query(BaseRequest<MemberQueryReqBean> req) throws BaseException {
        return call("consumer-cust/member/query", req);
    }
    /**
    * 方法的功能描述: 查询会员信息
    *
    * @author 12869
    * @createDate 2023-41-31 16:41:19
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberQueryResBean> query(String url,BaseRequest<MemberQueryReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询用户已购买的卡
     *
     * @author 12869
     * @createDate 2023-33-20 16:33:30
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberQueryCardResBean> queryCard(BaseRequest<MemberQueryCardReqBean> req) throws BaseException {
        return call("cust-benefits-intfc/openApi/queryCard", req);
    }
    /**
    * 方法的功能描述: 查询用户已购买的卡
    *
    * @author 12869
    * @createDate 2023-33-20 16:33:30
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberQueryCardResBean> queryCard(String url,BaseRequest<MemberQueryCardReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 校验用户能否有资格购买卡
     *
     * @author 12869
     * @createDate 2020-01-28 11:01:19
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberVerifyApplyCardResBean> verifyApplyCard(BaseRequest<MemberVerifyApplyCardReqBean> req) throws BaseException {
        return call("cust-benefits-intfc/openApi/verifyApplyCard", req);
    }
    /**
    * 方法的功能描述: 校验用户能否有资格购买卡
    *
    * @author 12869
    * @createDate 2020-01-28 11:01:19
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberVerifyApplyCardResBean> verifyApplyCard(String url,BaseRequest<MemberVerifyApplyCardReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 健合新客校验接口（美团定制）
     *
     * @author 13158
     * @createDate 2023-14-17 16:14:38
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberVerifykNewCustomerResBean> verifykNewCustomer(BaseRequest<MemberVerifykNewCustomerReqBean> req) throws BaseException {
        return call("consumer-cust/cust/verifykNewCustomer", req);
    }
    /**
    * 方法的功能描述: 健合新客校验接口（美团定制）
    *
    * @author 13158
    * @createDate 2023-14-17 16:14:38
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberVerifykNewCustomerResBean> verifykNewCustomer(String url,BaseRequest<MemberVerifykNewCustomerReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 是否企微的客户
     *
     * @author 12869
     * @createDate 2023-38-29 11:38:23
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberIsWeComResBean> isWeCom(BaseRequest<MemberIsWeComReqBean> req) throws BaseException {
        return call("consumer-cust/externalcontact/isWeCom", req);
    }
    /**
    * 方法的功能描述: 是否企微的客户
    *
    * @author 12869
    * @createDate 2023-38-29 11:38:23
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberIsWeComResBean> isWeCom(String url,BaseRequest<MemberIsWeComReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （废弃）同步会员：根据手机号码判断是否为新客，且同步会员信息
     *
     * @author 12360
     * @createDate 2019-15-04 16:15:52
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberSyncBbxNewCustomerResBean> syncBbxNewCustomer(BaseRequest<MemberSyncBbxNewCustomerReqBean> req) throws BaseException {
        return call("consumer-cust/cust/syncBbxNewCustomer", req);
    }
    /**
    * 方法的功能描述: （废弃）同步会员：根据手机号码判断是否为新客，且同步会员信息
    *
    * @author 12360
    * @createDate 2019-15-04 16:15:52
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberSyncBbxNewCustomerResBean> syncBbxNewCustomer(String url,BaseRequest<MemberSyncBbxNewCustomerReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （废弃）（WS）会员注册接口
     *
     * @author 13158
     * @createDate 2021-14-16 16:14:44
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberRegistWsCustResBean> registWsCust(BaseRequest<MemberRegistWsCustReqBean> req) throws BaseException {
        return call("consumer-cust/cust/registWsCust", req);
    }
    /**
    * 方法的功能描述: （废弃）（WS）会员注册接口
    *
    * @author 13158
    * @createDate 2021-14-16 16:14:44
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberRegistWsCustResBean> registWsCust(String url,BaseRequest<MemberRegistWsCustReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （废弃）判断是否为新客
     *
     * @author 11595
     * @createDate 2018-55-06 15:55:47
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCheckIsNewCilentResBean> checkIsNewCilent(BaseRequest<MemberCheckIsNewCilentReqBean> req) throws BaseException {
        return call("consumer-cust/cust/checkIsNewCilent", req);
    }
    /**
    * 方法的功能描述: （废弃）判断是否为新客
    *
    * @author 11595
    * @createDate 2018-55-06 15:55:47
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberCheckIsNewCilentResBean> checkIsNewCilent(String url,BaseRequest<MemberCheckIsNewCilentReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （废弃）(WS)添加会员的宝宝信息
     *
     * @author 13158
     * @createDate 2021-58-16 16:58:51
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberAddCustKidResBean> addCustKid(BaseRequest<MemberAddCustKidReqBean> req) throws BaseException {
        return call("consumer-cust/cust/addCustKid", req);
    }
    /**
    * 方法的功能描述: （废弃）(WS)添加会员的宝宝信息
    *
    * @author 13158
    * @createDate 2021-58-16 16:58:51
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberAddCustKidResBean> addCustKid(String url,BaseRequest<MemberAddCustKidReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （废弃）检查手机号是否已存在（是否已注册会员）
     *
     * @author 13158
     * @createDate 2021-59-10 15:59:36
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCheckMobileExistResBean> checkMobileExist(BaseRequest<MemberCheckMobileExistReqBean> req) throws BaseException {
        return call("consumer-cust/cust/checkMobileExist", req);
    }
    /**
    * 方法的功能描述: （废弃）检查手机号是否已存在（是否已注册会员）
    *
    * @author 13158
    * @createDate 2021-59-10 15:59:36
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberCheckMobileExistResBean> checkMobileExist(String url,BaseRequest<MemberCheckMobileExistReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 判断是否为异常顾客
     *
     * @author 13158
     * @createDate 2023-58-11 11:58:31
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCheckClientStatusResBean> checkClientStatus(BaseRequest<MemberCheckClientStatusReqBean> req) throws BaseException {
        return call("consumer-cust/cust/checkClientStatus", req);
    }
    /**
    * 方法的功能描述: 判断是否为异常顾客
    *
    * @author 13158
    * @createDate 2023-58-11 11:58:31
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberCheckClientStatusResBean> checkClientStatus(String url,BaseRequest<MemberCheckClientStatusReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 品类新客：根据手机号码、品类（项）判断是否为新客
     *
     * @author 13158
     * @createDate 2021-44-05 18:44:14
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCheckCategoryClientResBean> checkCategoryClient(BaseRequest<MemberCheckCategoryClientReqBean> req) throws BaseException {
        return call("consumer-cust/cust/checkCategoryClient", req);
    }
    /**
    * 方法的功能描述: 品类新客：根据手机号码、品类（项）判断是否为新客
    *
    * @author 13158
    * @createDate 2021-44-05 18:44:14
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberCheckCategoryClientResBean> checkCategoryClient(String url,BaseRequest<MemberCheckCategoryClientReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 通过unionId查询会员
     *
     * @author 12869
     * @createDate 2021-27-19 17:27:23
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberUnionIdResBean> unionId(BaseRequest<MemberUnionIdReqBean> req) throws BaseException {
        return call("promotion-biz/customer/query/by/unionId", req);
    }
    /**
    * 方法的功能描述: 通过unionId查询会员
    *
    * @author 12869
    * @createDate 2021-27-19 17:27:23
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberUnionIdResBean> unionId(String url,BaseRequest<MemberUnionIdReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （新）判断是否为新客
     *
     * @author 13158
     * @createDate 2020-07-06 18:07:16
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCheckNewClientV2ResBean> checkNewClientV2(BaseRequest<MemberCheckNewClientV2ReqBean> req) throws BaseException {
        return call("consumer-cust/cust/checkNewClientV2", req);
    }
    /**
    * 方法的功能描述: （新）判断是否为新客
    *
    * @author 13158
    * @createDate 2020-07-06 18:07:16
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberCheckNewClientV2ResBean> checkNewClientV2(String url,BaseRequest<MemberCheckNewClientV2ReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （WS）查询会员资料
     *
     * @author 13158
     * @createDate 2021-44-19 11:44:54
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberGetWsCustInfoResBean> getWsCustInfo(BaseRequest<MemberGetWsCustInfoReqBean> req) throws BaseException {
        return call("consumer-cust/cust/getWsCustInfo", req);
    }
    /**
    * 方法的功能描述: （WS）查询会员资料
    *
    * @author 13158
    * @createDate 2021-44-19 11:44:54
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberGetWsCustInfoResBean> getWsCustInfo(String url,BaseRequest<MemberGetWsCustInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: （WS）编辑会员信息
     *
     * @author 13158
     * @createDate 2021-14-22 16:14:11
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberEditWsCustInfoResBean> editWsCustInfo(BaseRequest<MemberEditWsCustInfoReqBean> req) throws BaseException {
        return call("consumer-cust/cust/editWsCustInfo", req);
    }
    /**
    * 方法的功能描述: （WS）编辑会员信息
    *
    * @author 13158
    * @createDate 2021-14-22 16:14:11
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberEditWsCustInfoResBean> editWsCustInfo(String url,BaseRequest<MemberEditWsCustInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 企业微信mama100注册
     *
     * @author 12869
     * @createDate 2021-54-16 13:54:29
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberMama100ResBean> mama100(BaseRequest<MemberMama100ReqBean> req) throws BaseException {
        return call("promotion-biz/register/wechatwork/mama100", req);
    }
    /**
    * 方法的功能描述: 企业微信mama100注册
    *
    * @author 12869
    * @createDate 2021-54-16 13:54:29
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberMama100ResBean> mama100(String url,BaseRequest<MemberMama100ReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 公共接口：根据手机号码注册会员，不判断是否为新客。
     *
     * @author 12869
     * @createDate 2020-52-07 15:52:53
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberSyncCommonNewCustomerV2ResBean> syncCommonNewCustomerV2(BaseRequest<MemberSyncCommonNewCustomerV2ReqBean> req) throws BaseException {
        return call("consumer-cust/cust/syncCommonNewCustomerV2", req);
    }
    /**
    * 方法的功能描述: 公共接口：根据手机号码注册会员，不判断是否为新客。
    *
    * @author 12869
    * @createDate 2020-52-07 15:52:53
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberSyncCommonNewCustomerV2ResBean> syncCommonNewCustomerV2(String url,BaseRequest<MemberSyncCommonNewCustomerV2ReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 任务状态回调接口
     *
     * @author 13351
     * @createDate 2019-47-29 12:47:59
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberTaskFinishResBean> taskFinish(BaseRequest<MemberTaskFinishReqBean> req) throws BaseException {
        return call("ai-phone-server/api/taskFinish", req);
    }
    /**
    * 方法的功能描述: 任务状态回调接口
    *
    * @author 13351
    * @createDate 2019-47-29 12:47:59
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberTaskFinishResBean> taskFinish(String url,BaseRequest<MemberTaskFinishReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 通话记录回调接口
     *
     * @author 13351
     * @createDate 2019-46-29 12:46:19
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCallFinishResBean> callFinish(BaseRequest<MemberCallFinishReqBean> req) throws BaseException {
        return call("ai-phone-server/api/callFinish", req);
    }
    /**
    * 方法的功能描述: 通话记录回调接口
    *
    * @author 13351
    * @createDate 2019-46-29 12:46:19
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberCallFinishResBean> callFinish(String url,BaseRequest<MemberCallFinishReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 手动修改客户意向等级回调接口
     *
     * @author 13351
     * @createDate 2019-47-29 12:47:06
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberChangeIntentionResBean> changeIntention(BaseRequest<MemberChangeIntentionReqBean> req) throws BaseException {
        return call("ai-phone-server/api/changeIntention", req);
    }
    /**
    * 方法的功能描述: 手动修改客户意向等级回调接口
    *
    * @author 13351
    * @createDate 2019-47-29 12:47:06
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MemberChangeIntentionResBean> changeIntention(String url,BaseRequest<MemberChangeIntentionReqBean> req) throws BaseException {
         return call(url, req);
    }


}
