package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryAccountInfoReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryAccountInfoResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantIncrementListReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantIncrementListResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantCategoryListReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantCategoryListResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantListReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantListResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantBindingUserAndHelperReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantBindingUserAndHelperResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendCommunityReportXiaoUFailMsgReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendCommunityReportXiaoUFailMsgResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendSystemMessageReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendSystemMessageResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentInfoReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentInfoResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentsResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据营销通app token或账号ID
查询登录人的账号基础信息，包含当前登录人所在的大区办事处。

角色类型定义如下：
1	合生元
2	长沙素加
3	Swisse人员
7	店主
8	店长
9	店员
10	综合促销员
11	KOL
12	Feichat
14	Swisse促销员
15	促销教练
38	微客
40	大区药线商务推广员
41	SA育婴顾问
42	品牌大使
43	商超特工
44	经销商业务员
45	业务精英
50	BNC活动精英
51	ANC活动精英
52	联营人员
 * @author: 3742
 * @date: 2018-45-07 11:45:03
 */
public class MerchantService extends BaseService {

    public MerchantService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询登录的账号信息
     *
     * @author 3742
     * @createDate 2018-45-07 11:45:03
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryAccountInfoResBean> queryAccountInfo(BaseRequest<MerchantQueryAccountInfoReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryAccountInfo", req);
    }
    /**
    * 方法的功能描述: 查询登录的账号信息
    *
    * @author 3742
    * @createDate 2018-45-07 11:45:03
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantQueryAccountInfoResBean> queryAccountInfo(String url,BaseRequest<MerchantQueryAccountInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询素材库增量列表
     *
     * @author 13004
     * @createDate 2021-40-12 15:40:16
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantIncrementListResBean> incrementList(BaseRequest<MerchantIncrementListReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/material/incrementList", req);
    }
    /**
    * 方法的功能描述: 查询素材库增量列表
    *
    * @author 13004
    * @createDate 2021-40-12 15:40:16
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantIncrementListResBean> incrementList(String url,BaseRequest<MerchantIncrementListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询素材库分类列表
     *
     * @author 13004
     * @createDate 2021-38-11 14:38:24
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantCategoryListResBean> categoryList(BaseRequest<MerchantCategoryListReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/material/categoryList", req);
    }
    /**
    * 方法的功能描述: 查询素材库分类列表
    *
    * @author 13004
    * @createDate 2021-38-11 14:38:24
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantCategoryListResBean> categoryList(String url,BaseRequest<MerchantCategoryListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询素材库列表
     *
     * @author 13004
     * @createDate 2021-23-08 14:23:45
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantListResBean> list(BaseRequest<MerchantListReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/material/list", req);
    }
    /**
    * 方法的功能描述: 查询素材库列表
    *
    * @author 13004
    * @createDate 2021-23-08 14:23:45
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantListResBean> list(String url,BaseRequest<MerchantListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 小U - 绑定用户和小助手信息
     *
     * @author 3742
     * @createDate 2020-42-13 16:42:38
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantBindingUserAndHelperResBean> bindingUserAndHelper(BaseRequest<MerchantBindingUserAndHelperReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/community/bindingUserAndHelper", req);
    }
    /**
    * 方法的功能描述: 小U - 绑定用户和小助手信息
    *
    * @author 3742
    * @createDate 2020-42-13 16:42:38
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantBindingUserAndHelperResBean> bindingUserAndHelper(String url,BaseRequest<MerchantBindingUserAndHelperReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 小U - 小助手封号或者异常时调用接口
     *
     * @author 3742
     * @createDate 2020-42-13 16:42:38
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantSendCommunityReportXiaoUFailMsgResBean> sendCommunityReportXiaoUFailMsg(BaseRequest<MerchantSendCommunityReportXiaoUFailMsgReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/community/sendCommunityReportXiaoUFailMsg", req);
    }
    /**
    * 方法的功能描述: 小U - 小助手封号或者异常时调用接口
    *
    * @author 3742
    * @createDate 2020-42-13 16:42:38
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantSendCommunityReportXiaoUFailMsgResBean> sendCommunityReportXiaoUFailMsg(String url,BaseRequest<MerchantSendCommunityReportXiaoUFailMsgReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 营销通app推送消息
     *
     * @author 3742
     * @createDate 2018-46-15 17:46:49
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantSendSystemMessageResBean> sendSystemMessage(BaseRequest<MerchantSendSystemMessageReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/sendSystemMessage", req);
    }
    /**
    * 方法的功能描述: 营销通app推送消息
    *
    * @author 3742
    * @createDate 2018-46-15 17:46:49
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantSendSystemMessageResBean> sendSystemMessage(String url,BaseRequest<MerchantSendSystemMessageReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询门店的大区办事处信息
     *
     * @author 3742
     * @createDate 2018-43-07 13:43:49
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryDepartmentInfoResBean> queryDepartmentInfo(BaseRequest<MerchantQueryDepartmentInfoReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryDepartmentInfo", req);
    }
    /**
    * 方法的功能描述: 查询门店的大区办事处信息
    *
    * @author 3742
    * @createDate 2018-43-07 13:43:49
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantQueryDepartmentInfoResBean> queryDepartmentInfo(String url,BaseRequest<MerchantQueryDepartmentInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询大区办事处列表
     *
     * @author 3742
     * @createDate 2018-55-12 15:55:20
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryDepartmentsResBean> queryDepartments(BaseRequest<Void> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryDepartments", req);
    }
    /**
    * 方法的功能描述: 查询大区办事处列表
    *
    * @author 3742
    * @createDate 2018-55-12 15:55:20
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantQueryDepartmentsResBean> queryDepartments(String url,BaseRequest<Void> req) throws BaseException {
         return call(url, req);
    }


}
