package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiGetOnhandReqBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiGetOnhandResBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiAddPOArriveorderReqBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiAddPOArriveorderResBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiAddPROorderReqBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiAddPROorderResBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiGetPOorderReqBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiGetPOorderResBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiUpdatePROorderReqBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiUpdatePROorderResBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiAddPOorderReqBean;
import global.hh.openapi.sdk.api.bean.nccservice.NccserviceOpenApiAddPOorderResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: NCC-现存量查询接口
 * @author: 23518
 * @date: 2023-24-17 16:24:19
 */
public class NccServiceService extends BaseService {

    public NccServiceService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: NCC-现存量查询接口
     *
     * @author 23518
     * @createDate 2023-24-17 16:24:19
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<NccserviceOpenApiGetOnhandResBean> openApiGetOnhand(BaseRequest<NccserviceOpenApiGetOnhandReqBean> req) throws BaseException {
        return call("hh-ncc-service/external/customization/proorder/openApiGetOnhand", req);
    }
    /**
    * 方法的功能描述: NCC-现存量查询接口
    *
    * @author 23518
    * @createDate 2023-24-17 16:24:19
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<NccserviceOpenApiGetOnhandResBean> openApiGetOnhand(String url,BaseRequest<NccserviceOpenApiGetOnhandReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: NCC-到货单新增接口
     *
     * @author 23518
     * @createDate 2023-24-17 16:24:19
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<NccserviceOpenApiAddPOArriveorderResBean> openApiAddPOArriveorder(BaseRequest<NccserviceOpenApiAddPOArriveorderReqBean> req) throws BaseException {
        return call("hh-ncc-service/external/scm/purchase/openApiAddPOArriveorder", req);
    }
    /**
    * 方法的功能描述: NCC-到货单新增接口
    *
    * @author 23518
    * @createDate 2023-24-17 16:24:19
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<NccserviceOpenApiAddPOArriveorderResBean> openApiAddPOArriveorder(String url,BaseRequest<NccserviceOpenApiAddPOArriveorderReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: NCC-预占单新增接口
     *
     * @author 23518
     * @createDate 2023-28-20 09:28:52
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<NccserviceOpenApiAddPROorderResBean> openApiAddPROorder(BaseRequest<NccserviceOpenApiAddPROorderReqBean> req) throws BaseException {
        return call("hh-ncc-service/external/customization/proorder/openApiAddPROorder", req);
    }
    /**
    * 方法的功能描述: NCC-预占单新增接口
    *
    * @author 23518
    * @createDate 2023-28-20 09:28:52
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<NccserviceOpenApiAddPROorderResBean> openApiAddPROorder(String url,BaseRequest<NccserviceOpenApiAddPROorderReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: NCC-采购订单查询
     *
     * @author 23518
     * @createDate 2023-24-17 16:24:20
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<NccserviceOpenApiGetPOorderResBean> openApiGetPOorder(BaseRequest<NccserviceOpenApiGetPOorderReqBean> req) throws BaseException {
        return call("hh-ncc-service/external/scm/purchase/openApiGetPOorder", req);
    }
    /**
    * 方法的功能描述: NCC-采购订单查询
    *
    * @author 23518
    * @createDate 2023-24-17 16:24:20
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<NccserviceOpenApiGetPOorderResBean> openApiGetPOorder(String url,BaseRequest<NccserviceOpenApiGetPOorderReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: NCC-预占单修改接口
     *
     * @author 23518
     * @createDate 2023-28-20 09:28:52
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<NccserviceOpenApiUpdatePROorderResBean> openApiUpdatePROorder(BaseRequest<NccserviceOpenApiUpdatePROorderReqBean> req) throws BaseException {
        return call("hh-ncc-service/external/customization/proorder/openApiUpdatePROorder", req);
    }
    /**
    * 方法的功能描述: NCC-预占单修改接口
    *
    * @author 23518
    * @createDate 2023-28-20 09:28:52
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<NccserviceOpenApiUpdatePROorderResBean> openApiUpdatePROorder(String url,BaseRequest<NccserviceOpenApiUpdatePROorderReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: NCC-采购订单新增接口
     *
     * @author 23518
     * @createDate 2023-28-20 09:28:52
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<NccserviceOpenApiAddPOorderResBean> openApiAddPOorder(BaseRequest<NccserviceOpenApiAddPOorderReqBean> req) throws BaseException {
        return call("hh-ncc-service/external/scm/purchase/openApiAddPOorder", req);
    }
    /**
    * 方法的功能描述: NCC-采购订单新增接口
    *
    * @author 23518
    * @createDate 2023-28-20 09:28:52
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<NccserviceOpenApiAddPOorderResBean> openApiAddPOorder(String url,BaseRequest<NccserviceOpenApiAddPOorderReqBean> req) throws BaseException {
         return call(url, req);
    }


}
