package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetTerminalListReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetTerminalListResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetSimpleListReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetSimpleListResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetIncrementPromoterAndTerminalByTimeReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetIncrementPromoterAndTerminalByTimeResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidPromoterAndTerminalAllReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidPromoterAndTerminalAllResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetIncrementTerminalByTimeReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetIncrementTerminalByTimeResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidTerminalAllReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidTerminalAllResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidTerminalByBatchUserIdReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidTerminalByBatchUserIdResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidTerminalByAccountReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetValidTerminalByAccountResBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetFailTerminalByTimeReqBean;
import global.hh.openapi.sdk.api.bean.terminal.TerminalGetFailTerminalByTimeResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 批量查询终端是否存在,筛选不存在的终端
 * @author: 23465
 * @date: 2023-44-05 11:44:15
 */
public class TerminalService extends BaseService {

    public TerminalService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 批量查询终端是否存在
     *
     * @author 23465
     * @createDate 2023-44-05 11:44:15
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetTerminalListResBean> getTerminalList(BaseRequest<TerminalGetTerminalListReqBean> req) throws BaseException {
        return call("terminal-service/terminal/getTerminalList", req);
    }
    /**
    * 方法的功能描述: 批量查询终端是否存在
    *
    * @author 23465
    * @createDate 2023-44-05 11:44:15
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetTerminalListResBean> getTerminalList(String url,BaseRequest<TerminalGetTerminalListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 终端主数据
     *
     * @author 23465
     * @createDate 2023-42-13 21:42:11
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetSimpleListResBean> getSimpleList(BaseRequest<TerminalGetSimpleListReqBean> req) throws BaseException {
        return call("terminal-service/terminal/getSimpleList", req);
    }
    /**
    * 方法的功能描述: 终端主数据
    *
    * @author 23465
    * @createDate 2023-42-13 21:42:11
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetSimpleListResBean> getSimpleList(String url,BaseRequest<TerminalGetSimpleListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 根据传入的时间戳获取增量促销员与终端关系（包括有效,失效）
     *
     * @author 13258
     * @createDate 2021-08-29 16:08:04
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetIncrementPromoterAndTerminalByTimeResBean> getIncrementPromoterAndTerminalByTime(BaseRequest<TerminalGetIncrementPromoterAndTerminalByTimeReqBean> req) throws BaseException {
        return call("account-terminal-service/accountTerminal/getIncrementPromoterAndTerminalByTime", req);
    }
    /**
    * 方法的功能描述: 根据传入的时间戳获取增量促销员与终端关系（包括有效,失效）
    *
    * @author 13258
    * @createDate 2021-08-29 16:08:04
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetIncrementPromoterAndTerminalByTimeResBean> getIncrementPromoterAndTerminalByTime(String url,BaseRequest<TerminalGetIncrementPromoterAndTerminalByTimeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取全量有效促销员与终端关系
     *
     * @author 13258
     * @createDate 2021-03-29 16:03:56
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetValidPromoterAndTerminalAllResBean> getValidPromoterAndTerminalAll(BaseRequest<TerminalGetValidPromoterAndTerminalAllReqBean> req) throws BaseException {
        return call("account-terminal-service/accountTerminal/getValidPromoterAndTerminalAll", req);
    }
    /**
    * 方法的功能描述: 获取全量有效促销员与终端关系
    *
    * @author 13258
    * @createDate 2021-03-29 16:03:56
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetValidPromoterAndTerminalAllResBean> getValidPromoterAndTerminalAll(String url,BaseRequest<TerminalGetValidPromoterAndTerminalAllReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 根据传入的时间戳获取增量终端（包括有效,失效）
     *
     * @author 13258
     * @createDate 2021-44-09 14:44:30
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetIncrementTerminalByTimeResBean> getIncrementTerminalByTime(BaseRequest<TerminalGetIncrementTerminalByTimeReqBean> req) throws BaseException {
        return call("account-terminal-service/accountTerminal/getIncrementTerminalByTime", req);
    }
    /**
    * 方法的功能描述: 根据传入的时间戳获取增量终端（包括有效,失效）
    *
    * @author 13258
    * @createDate 2021-44-09 14:44:30
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetIncrementTerminalByTimeResBean> getIncrementTerminalByTime(String url,BaseRequest<TerminalGetIncrementTerminalByTimeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取全量有效终端
     *
     * @author 13258
     * @createDate 2021-46-10 13:46:41
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetValidTerminalAllResBean> getValidTerminalAll(BaseRequest<TerminalGetValidTerminalAllReqBean> req) throws BaseException {
        return call("account-terminal-service/accountTerminal/getValidTerminalAll", req);
    }
    /**
    * 方法的功能描述: 获取全量有效终端
    *
    * @author 13258
    * @createDate 2021-46-10 13:46:41
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetValidTerminalAllResBean> getValidTerminalAll(String url,BaseRequest<TerminalGetValidTerminalAllReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 批量获取促销员关联的有效终端
     *
     * @author 13258
     * @createDate 2021-44-14 14:44:03
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetValidTerminalByBatchUserIdResBean> getValidTerminalByBatchUserId(BaseRequest<TerminalGetValidTerminalByBatchUserIdReqBean> req) throws BaseException {
        return call("account-terminal-service/accountTerminal/getValidTerminalByBatchUserId", req);
    }
    /**
    * 方法的功能描述: 批量获取促销员关联的有效终端
    *
    * @author 13258
    * @createDate 2021-44-14 14:44:03
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetValidTerminalByBatchUserIdResBean> getValidTerminalByBatchUserId(String url,BaseRequest<TerminalGetValidTerminalByBatchUserIdReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取促销员关联的有效终端
     *
     * @author 13258
     * @createDate 2021-44-09 14:44:29
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetValidTerminalByAccountResBean> getValidTerminalByAccount(BaseRequest<TerminalGetValidTerminalByAccountReqBean> req) throws BaseException {
        return call("account-terminal-service/accountTerminal/getValidTerminalByAccount", req);
    }
    /**
    * 方法的功能描述: 获取促销员关联的有效终端
    *
    * @author 13258
    * @createDate 2021-44-09 14:44:29
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetValidTerminalByAccountResBean> getValidTerminalByAccount(String url,BaseRequest<TerminalGetValidTerminalByAccountReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 根据传入的时间戳获取失效终端
     *
     * @author 13258
     * @createDate 2021-51-25 14:51:38
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TerminalGetFailTerminalByTimeResBean> getFailTerminalByTime(BaseRequest<TerminalGetFailTerminalByTimeReqBean> req) throws BaseException {
        return call("account-terminal-service/accountTerminal/getFailTerminalByTime", req);
    }
    /**
    * 方法的功能描述: 根据传入的时间戳获取失效终端
    *
    * @author 13258
    * @createDate 2021-51-25 14:51:38
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TerminalGetFailTerminalByTimeResBean> getFailTerminalByTime(String url,BaseRequest<TerminalGetFailTerminalByTimeReqBean> req) throws BaseException {
         return call(url, req);
    }


}
