package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.testb.TestbTwelveReqBean;
import global.hh.openapi.sdk.api.bean.testb.TestbTwelveResBean;
import global.hh.openapi.sdk.api.bean.testb.TestbElevenReqBean;
import global.hh.openapi.sdk.api.bean.testb.TestbElevenResBean;
import global.hh.openapi.sdk.api.bean.testb.TestbNineReqBean;
import global.hh.openapi.sdk.api.bean.testb.TestbNineResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 接口7描述
 * @author: 12487
 * @date: 2019-29-04 14:29:12
 */
public class TestbService extends BaseService {

    public TestbService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: interface7
     *
     * @author 12487
     * @createDate 2019-29-04 14:29:12
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<Void> seven(BaseRequest<Void> req) throws BaseException {
        return call("two/two/seven", req);
    }
    /**
    * 方法的功能描述: interface7
    *
    * @author 12487
    * @createDate 2019-29-04 14:29:12
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<Void> seven(String url,BaseRequest<Void> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 接口12
     *
     * @author 12487
     * @createDate 2019-37-08 15:37:12
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TestbTwelveResBean> twelve(BaseRequest<TestbTwelveReqBean> req) throws BaseException {
        return call("two/two/twelve", req);
    }
    /**
    * 方法的功能描述: 接口12
    *
    * @author 12487
    * @createDate 2019-37-08 15:37:12
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TestbTwelveResBean> twelve(String url,BaseRequest<TestbTwelveReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 接口11
     *
     * @author 12487
     * @createDate 2019-49-08 14:49:49
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TestbElevenResBean> eleven(BaseRequest<TestbElevenReqBean> req) throws BaseException {
        return call("two/two/eleven", req);
    }
    /**
    * 方法的功能描述: 接口11
    *
    * @author 12487
    * @createDate 2019-49-08 14:49:49
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TestbElevenResBean> eleven(String url,BaseRequest<TestbElevenReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 接口9
     *
     * @author 12487
     * @createDate 2019-39-07 13:39:25
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TestbNineResBean> nine(BaseRequest<TestbNineReqBean> req) throws BaseException {
        return call("two/two/nine", req);
    }
    /**
    * 方法的功能描述: 接口9
    *
    * @author 12487
    * @createDate 2019-39-07 13:39:25
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TestbNineResBean> nine(String url,BaseRequest<TestbNineReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 接口8
     *
     * @author 12487
     * @createDate 2019-50-04 16:50:03
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<Void> eight(BaseRequest<Void> req) throws BaseException {
        return call("two/two/eight", req);
    }
    /**
    * 方法的功能描述: 接口8
    *
    * @author 12487
    * @createDate 2019-50-04 16:50:03
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<Void> eight(String url,BaseRequest<Void> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: interface6
     *
     * @author 12487
     * @createDate 2019-21-04 14:21:28
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<Void> six(BaseRequest<Void> req) throws BaseException {
        return call("two/two/six", req);
    }
    /**
    * 方法的功能描述: interface6
    *
    * @author 12487
    * @createDate 2019-21-04 14:21:28
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<Void> six(String url,BaseRequest<Void> req) throws BaseException {
         return call(url, req);
    }


}
