package global.hh.openapi.sdk.config;


import global.hh.openapi.sdk.api.base.SignatureAlgorithmEnum;
import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.exception.BusinessException;
import global.hh.openapi.sdk.utils.StringUtils;

/**
 * 方法的功能描述: 配置信息
 *
 * @param
 * @author 3742
 * @createDate 2018-11-23 19:41
 * @return
 */
public class Config {

    private String accessKey;
    private String secretKey;
    private String signMethod;
    private String domain;
    private BiostimeSdkLogger biostimeSdkLogger;
    private boolean sandbox;


    public Config(boolean sandbox, String accessKey, String secretKey) throws BaseException {
        this(sandbox, accessKey, secretKey, SignatureAlgorithmEnum.MD5, null);
    }

    public Config(boolean sandbox, String accessKey, String secretKey, BiostimeSdkLogger biostimeSdkLogger) throws BaseException {
        this(sandbox, accessKey, secretKey, SignatureAlgorithmEnum.MD5, biostimeSdkLogger);
    }

    /**
     * 方法的功能描述: 初始化配置信息
     *
     * @param accessKey          访问key
     * @param secretKey          密钥key
     * @param sandbox            是否是沙箱环境，sandbox=true：沙箱环境，sandbox=false：生产环境
     * @param signatureAlgorithm 签名算法，不传默认是MD5
     * @param biostimeSdkLogger  第三方日志实现类
     * @return
     * @author 3742
     * @createDate 2018-11-23 14:32
     */
    public Config(boolean sandbox, String accessKey, String secretKey, SignatureAlgorithmEnum signatureAlgorithm, BiostimeSdkLogger biostimeSdkLogger) throws BaseException {
        if (StringUtils.isEmpty(accessKey)) {
            throw new BusinessException("accessKey 不能为空值");
        }
        if (StringUtils.isEmpty(secretKey)) {
            throw new BusinessException("secretKey 不能为空值");
        }
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sandbox = sandbox;
        this.signMethod = signatureAlgorithm.getAlgorithm();
        this.biostimeSdkLogger = biostimeSdkLogger;
        domain = sandbox ? Constants.SANDBOX_DOMAIN : Constants.PRODUCTION_DOMAIN;
    }


    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSignMethod() {
        return signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public BiostimeSdkLogger getBiostimeSdkLogger() {
        return biostimeSdkLogger;
    }

    public void setBiostimeSdkLogger(BiostimeSdkLogger biostimeSdkLogger) {
        this.biostimeSdkLogger = biostimeSdkLogger;
    }

    public boolean isSandbox() {
        return sandbox;
    }

    public void setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
    }
}
