/*
 * Decompiled with CFR 0.152.
 */
package global.hh.openapi.sdk.api.base;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.utils.JsonUtils;
import global.hh.openapi.sdk.utils.SignatureUtils;
import global.hh.openapi.sdk.utils.httpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BaseService {
    private Config config;

    public BaseService(Config config) {
        this.config = config;
    }

    public BaseResponse call(String uri, BaseRequest req) throws BaseException {
        Map<String, Object> publicParams = this.buildPublicParams();
        Map<String, Object> businessParams = null;
        if (req.getRequest() != null) {
            businessParams = JsonUtils.toMap(JsonUtils.toJson(req.getRequest()));
        }
        String signature = SignatureUtils.generateSignature(publicParams, businessParams, this.config.getSecretKey());
        String requestBody = this.buildRequestBody(publicParams, businessParams, signature);
        String jsonResult = httpUtils.doPost(this.config, this.config.getDomain() + uri, requestBody);
        return JsonUtils.toObject(jsonResult, BaseResponse.class);
    }

    private Map<String, Object> buildPublicParams() {
        HashMap<String, Object> publicParams = new HashMap<String, Object>(10);
        publicParams.put("seqNo", this.generateUUID());
        publicParams.put("accessKey", this.config.getAccessKey());
        publicParams.put("signMethod", this.config.getSignMethod());
        publicParams.put("timestamp", System.currentTimeMillis());
        publicParams.put("version", "1.0.0");
        return publicParams;
    }

    private String buildRequestBody(Map<String, Object> publicParams, Map<String, Object> businessParams, String signature) throws BaseException {
        HashMap<String, Object> requestParams = new HashMap<String, Object>(20);
        requestParams.putAll(publicParams);
        requestParams.put("sign", signature);
        if (businessParams != null && !businessParams.isEmpty()) {
            requestParams.put("request", businessParams);
        }
        String callApiBody = JsonUtils.toJson(requestParams);
        return callApiBody;
    }

    public String generateUUID() {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        if (uuid.length() > 32) {
            uuid = uuid.substring(0, 32);
        }
        return uuid.toUpperCase();
    }
}

