/*
 * Decompiled with CFR 0.152.
 */
package global.hh.openapi.sdk.config;

import global.hh.openapi.sdk.api.base.SignatureAlgorithmEnum;
import global.hh.openapi.sdk.config.BiostimeSdkLogger;
import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.exception.BusinessException;
import global.hh.openapi.sdk.utils.StringUtils;

public class Config {
    private String accessKey;
    private String secretKey;
    private String signMethod;
    private String domain;
    private BiostimeSdkLogger biostimeSdkLogger;
    private boolean sandbox;

    public Config(boolean sandbox, String accessKey, String secretKey) throws BaseException {
        this(sandbox, accessKey, secretKey, SignatureAlgorithmEnum.MD5, null);
    }

    public Config(boolean sandbox, String accessKey, String secretKey, BiostimeSdkLogger biostimeSdkLogger) throws BaseException {
        this(sandbox, accessKey, secretKey, SignatureAlgorithmEnum.MD5, biostimeSdkLogger);
    }

    public Config(boolean sandbox, String accessKey, String secretKey, SignatureAlgorithmEnum signatureAlgorithm, BiostimeSdkLogger biostimeSdkLogger) throws BaseException {
        if (StringUtils.isEmpty(accessKey)) {
            throw new BusinessException("accessKey \u4e0d\u80fd\u4e3a\u7a7a\u503c");
        }
        if (StringUtils.isEmpty(secretKey)) {
            throw new BusinessException("secretKey \u4e0d\u80fd\u4e3a\u7a7a\u503c");
        }
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sandbox = sandbox;
        this.signMethod = signatureAlgorithm.getAlgorithm();
        this.biostimeSdkLogger = biostimeSdkLogger;
        this.domain = sandbox ? "https://p.mama100.cn/open-api/" : "https://api.biostime.com/";
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public BiostimeSdkLogger getBiostimeSdkLogger() {
        return this.biostimeSdkLogger;
    }

    public void setBiostimeSdkLogger(BiostimeSdkLogger biostimeSdkLogger) {
        this.biostimeSdkLogger = biostimeSdkLogger;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public void setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
    }
}

