/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;

public interface GroupCapacityMapper
extends Mapper {
    default public MapperResult insertIntoSelect(MapperContext context) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("groupId"));
        paramList.add(context.getUpdateParameter("quota"));
        paramList.add(context.getUpdateParameter("maxSize"));
        paramList.add(context.getUpdateParameter("maxAggrCount"));
        paramList.add(context.getUpdateParameter("maxAggrSize"));
        paramList.add(context.getUpdateParameter("gmtCreate"));
        paramList.add(context.getUpdateParameter("gmtModified"));
        String sql = "INSERT INTO group_capacity (group_id, quota, usage, max_size, max_aggr_count, max_aggr_size,gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info";
        return new MapperResult(sql, paramList);
    }

    default public MapperResult insertIntoSelectByWhere(MapperContext context) {
        String sql = "INSERT INTO group_capacity (group_id, quota, usage, max_size, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info WHERE group_id=? AND tenant_id = '" + NamespaceUtil.getNamespaceDefaultId() + "'";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("groupId"));
        paramList.add(context.getUpdateParameter("quota"));
        paramList.add(context.getUpdateParameter("maxSize"));
        paramList.add(context.getUpdateParameter("maxAggrCount"));
        paramList.add(context.getUpdateParameter("maxAggrSize"));
        paramList.add(context.getUpdateParameter("gmtCreate"));
        paramList.add(context.getUpdateParameter("gmtModified"));
        paramList.add(context.getWhereParameter("groupId"));
        return new MapperResult(sql, paramList);
    }

    default public MapperResult incrementUsageByWhereQuotaEqualZero(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ? AND usage < ? AND quota = 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId"), context.getWhereParameter("usage")}));
    }

    default public MapperResult incrementUsageByWhereQuotaNotEqualZero(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ? AND usage < quota AND quota != 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    default public MapperResult incrementUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ?", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    default public MapperResult decrementUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage - 1, gmt_modified = ? WHERE group_id = ? AND usage > 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    default public MapperResult updateUsage(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = (SELECT count(*) FROM config_info), gmt_modified = ? WHERE group_id = ?", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    default public MapperResult updateUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = (SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id = '" + NamespaceUtil.getNamespaceDefaultId() + "'), gmt_modified = ? WHERE group_id= ?", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("groupId"), context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    public MapperResult selectGroupInfoBySize(MapperContext var1);

    @Override
    default public String getTableName() {
        return "group_capacity";
    }
}

