/*
 * Decompiled with CFR 0.152.
 */
package global.hh.openapi.sdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.exception.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static final ObjectMapper getInstance() {
        return objectMapper;
    }

    public static String toJson(Object obj) throws BaseException {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException();
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) throws BaseException {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static <T> T toObject(String jsonString, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtils.getInstance().readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, JavaType javaType) throws BaseException {
        try {
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static Map<String, Object> toMap(String json) throws BaseException {
        try {
            return (Map)objectMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static <T> Map<String, T> toMap(String json, Class<T> clazz) throws BaseException {
        Map map;
        try {
            map = (Map)objectMapper.readValue(json, new TypeReference<Map<String, T>>(){});
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), JsonUtils.mapToObject((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static <T> List<T> toList(String json, Class<T> clazz) throws BaseException {
        List list = null;
        try {
            list = (List)objectMapper.readValue(json, new TypeReference<List<T>>(){});
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Map map : list) {
            result.add(JsonUtils.mapToObject(map, clazz));
        }
        return result;
    }

    public static <T> T mapToObject(Map map, Class<T> clazz) {
        return (T)objectMapper.convertValue((Object)map, clazz);
    }

    static {
        objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }
}

