/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.spamsum;

public class ESSum {
    protected static final long HASH_PRIME = 16777619L;
    protected static final long HASH_INIT = 671226215L;
    protected static final long UINT32 = 0x100000000L;
    protected int MIN_BLOCKSIZE = 3;
    protected int SPAMSUM_LENGTH = 64;
    protected int CHARACTERS = 64;
    protected int blocksize;
    protected int[] signature;
    protected static final int ROLLING_WINDOW = 7;
    protected long[] rolling_window;
    protected long rolling_h1;
    protected long rolling_h2;
    protected long rolling_h3;
    protected long rolling_n;

    public static void main(String[] args) {
        String s1 = "This is a string that might be a spam... Depends on the hash, if it looks like a known hash...\n";
        ESSum ess = new ESSum(2, 1000, 1);
        int[] hash = ess.HashString(s1);
        System.out.println(hash[0]);
    }

    public ESSum(int stages, int buckets, int min_blocksize) {
        this.SPAMSUM_LENGTH = stages;
        this.CHARACTERS = buckets;
        this.MIN_BLOCKSIZE = min_blocksize;
    }

    public ESSum(int stages, int buckets) {
        this.SPAMSUM_LENGTH = stages;
        this.CHARACTERS = buckets;
    }

    public ESSum() {
    }

    public int[] HashString(String string) {
        return this.HashString(string, 0);
    }

    public int[] HashString(String string, int bsize) {
        byte[] in = string.getBytes();
        int length = in.length;
        if (bsize == 0) {
            this.blocksize = this.MIN_BLOCKSIZE;
            while (this.blocksize * this.SPAMSUM_LENGTH < length) {
                this.blocksize *= 2;
            }
        } else {
            this.blocksize = bsize;
        }
        while (true) {
            this.signature = new int[this.SPAMSUM_LENGTH];
            int k = 0;
            int j = 0;
            long h3 = 671226215L;
            long h2 = 671226215L;
            long h = this.rolling_hash_reset();
            for (int i = 0; i < length; ++i) {
                int character = (in[i] + 256) % 256;
                h = this.rolling_hash(character);
                h2 = ESSum.sum_hash(character, h2);
                h3 = ESSum.sum_hash(character, h3);
                if (h % (long)this.blocksize == (long)(this.blocksize - 1)) {
                    this.signature[j] = (int)(h2 % (long)this.CHARACTERS);
                    if (j < this.SPAMSUM_LENGTH - 1) {
                        h2 = 671226215L;
                        ++j;
                    }
                }
                if (h % (long)(this.blocksize * 2) != (long)(this.blocksize * 2 - 1) || k >= this.SPAMSUM_LENGTH / 2 - 1) continue;
                h3 = 671226215L;
                ++k;
            }
            if (h != 0L) {
                this.signature[j] = (int)(h2 % (long)this.CHARACTERS);
            }
            if (bsize != 0 || this.blocksize <= this.MIN_BLOCKSIZE || j >= this.SPAMSUM_LENGTH / 2) break;
            this.blocksize /= 2;
        }
        return this.signature;
    }

    public long BlockSize() {
        return this.blocksize;
    }

    protected static long sum_hash(long c, long h) {
        h = h * 16777619L % 0x100000000L;
        h = (h ^ c) % 0x100000000L;
        return h;
    }

    protected long rolling_hash(long c) {
        this.rolling_h2 -= this.rolling_h1;
        this.rolling_h2 = (this.rolling_h2 + 7L * c) % 0x100000000L;
        this.rolling_h1 = (this.rolling_h1 + c) % 0x100000000L;
        this.rolling_h1 -= this.rolling_window[(int)this.rolling_n % 7];
        this.rolling_window[(int)(this.rolling_n % 7L)] = c;
        ++this.rolling_n;
        this.rolling_h3 = (this.rolling_h3 << 5 & 0xFFFFFFFFFFFFFFFFL) % 0x100000000L;
        this.rolling_h3 = (this.rolling_h3 ^ c) % 0x100000000L;
        return (this.rolling_h1 + this.rolling_h2 + this.rolling_h3) % 0x100000000L;
    }

    protected long rolling_hash_reset() {
        this.rolling_window = new long[7];
        this.rolling_h1 = 0L;
        this.rolling_h2 = 0L;
        this.rolling_h3 = 0L;
        this.rolling_n = 0L;
        return 0L;
    }
}

