/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.spamsum;

import info.debatty.java.stringsimilarity.Levenshtein;

public class SpamSum {
    protected static final long HASH_PRIME = 16777619L;
    protected static final long HASH_INIT = 671226215L;
    protected static final char[] B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    protected static final long UINT32 = 0x100000000L;
    protected int MIN_BLOCKSIZE = 3;
    protected int SPAMSUM_LENGTH = 64;
    protected int CHARACTERS = 64;
    protected int blocksize;
    protected char[] left;
    protected char[] right;
    protected static final int ROLLING_WINDOW = 7;
    protected long[] rolling_window;
    protected long rolling_h1;
    protected long rolling_h2;
    protected long rolling_h3;
    protected long rolling_n;

    public static void main(String[] args) {
        String s1 = "This is a string that might be a spam... Depends on the hash, if it looks like a known hash...\n";
        String s2 = "Play to win \u0096 Download Casino King Spin now\n";
        SpamSum s = new SpamSum();
        System.out.println(s.HashString(s1));
        System.out.println(s.Left());
        System.out.println(s.HashString(s2));
    }

    public String HashString(String string) {
        return this.HashString(string, 0);
    }

    public String HashString(String string, int bsize) {
        byte[] in = string.getBytes();
        int length = in.length;
        if (bsize == 0) {
            this.blocksize = this.MIN_BLOCKSIZE;
            while (this.blocksize * this.SPAMSUM_LENGTH < length) {
                this.blocksize *= 2;
            }
        } else {
            this.blocksize = bsize;
        }
        while (true) {
            this.left = new char[this.SPAMSUM_LENGTH];
            this.right = new char[this.SPAMSUM_LENGTH];
            int k = 0;
            int j = 0;
            long h3 = 671226215L;
            long h2 = 671226215L;
            long h = this.rolling_hash_reset();
            for (int i = 0; i < length; ++i) {
                int character = (in[i] + 256) % 256;
                h = this.rolling_hash(character);
                h2 = SpamSum.sum_hash(character, h2);
                h3 = SpamSum.sum_hash(character, h3);
                if (h % (long)this.blocksize == (long)(this.blocksize - 1)) {
                    this.left[j] = B64[(int)(h2 % (long)this.CHARACTERS)];
                    if (j < this.SPAMSUM_LENGTH - 1) {
                        h2 = 671226215L;
                        ++j;
                    }
                }
                if (h % (long)(this.blocksize * 2) != (long)(this.blocksize * 2 - 1)) continue;
                this.right[k] = B64[(int)(h3 % (long)this.CHARACTERS)];
                if (k >= this.SPAMSUM_LENGTH / 2 - 1) continue;
                h3 = 671226215L;
                ++k;
            }
            if (h != 0L) {
                this.left[j] = B64[(int)(h2 % (long)this.CHARACTERS)];
                this.right[k] = B64[(int)(h3 % (long)this.CHARACTERS)];
            }
            if (bsize != 0 || this.blocksize <= this.MIN_BLOCKSIZE || j >= this.SPAMSUM_LENGTH / 2) break;
            this.blocksize /= 2;
        }
        return this.toString();
    }

    public String toString() {
        return "" + this.blocksize + ":" + this.Left() + ":" + this.Right();
    }

    public long BlockSize() {
        return this.blocksize;
    }

    public String Left() {
        return String.valueOf(this.left).trim();
    }

    public String Right() {
        return String.valueOf(this.right).trim();
    }

    protected static long sum_hash(long c, long h) {
        h = h * 16777619L % 0x100000000L;
        h = (h ^ c) % 0x100000000L;
        return h;
    }

    protected long rolling_hash(long c) {
        this.rolling_h2 -= this.rolling_h1;
        this.rolling_h2 = (this.rolling_h2 + 7L * c) % 0x100000000L;
        this.rolling_h1 = (this.rolling_h1 + c) % 0x100000000L;
        this.rolling_h1 -= this.rolling_window[(int)this.rolling_n % 7];
        this.rolling_window[(int)(this.rolling_n % 7L)] = c;
        ++this.rolling_n;
        this.rolling_h3 = (this.rolling_h3 << 5 & 0xFFFFFFFFFFFFFFFFL) % 0x100000000L;
        this.rolling_h3 = (this.rolling_h3 ^ c) % 0x100000000L;
        return (this.rolling_h1 + this.rolling_h2 + this.rolling_h3) % 0x100000000L;
    }

    protected long rolling_hash_reset() {
        this.rolling_window = new long[7];
        this.rolling_h1 = 0L;
        this.rolling_h2 = 0L;
        this.rolling_h3 = 0L;
        this.rolling_n = 0L;
        return 0L;
    }

    public int match(String str1, String str2) {
        int block_size2;
        String[] split1 = str1.split(":", 2);
        String[] split2 = str2.split(":", 2);
        if (split1.length != 2 || split2.length != 2) {
            return 0;
        }
        int block_size1 = Integer.parseInt(split1[0]);
        if (block_size1 != (block_size2 = Integer.parseInt(split2[0])) && block_size1 != block_size2 * 2 && block_size2 != block_size1 * 2) {
            return 0;
        }
        str1 = split1[1];
        str2 = split2[1];
        String s1 = this.eliminateSequences(str1);
        String s2 = this.eliminateSequences(str2);
        String s1_1 = s1;
        String s2_1 = s2;
        String s1_2 = ":" + s1.split(":")[1];
        String s2_2 = ":" + s2.split(":")[1];
        if (block_size1 == block_size2) {
            return Math.max(this.score(s1_1, s2_1, block_size1), this.score(s1_2, s2_2, block_size1));
        }
        if (block_size1 == block_size2 * 2) {
            return this.score(s1_1, s2_2, block_size1);
        }
        return this.score(s1_2, s2_1, block_size2);
    }

    private int score(String s1, String s2, int block_size) {
        int len1 = s1.length();
        int len2 = s2.length();
        if (len1 > this.SPAMSUM_LENGTH || len2 > this.SPAMSUM_LENGTH) {
            return 0;
        }
        Levenshtein levenshtein = new Levenshtein();
        int score = (int)levenshtein.distance(s1, s2);
        score = score * this.SPAMSUM_LENGTH / (len1 + len2);
        if ((score = 100 * score / 64) >= 100) {
            return 0;
        }
        if ((score = 100 - score) > block_size / this.MIN_BLOCKSIZE * Math.min(len1, len2)) {
            score = block_size / this.MIN_BLOCKSIZE * Math.min(len1, len2);
        }
        return score;
    }

    private String eliminateSequences(String str) {
        char[] str_array = str.toCharArray();
        char[] ret = str.toCharArray();
        int len = ret.length;
        int j = 3;
        for (int i = 3; i < len; ++i) {
            if (str_array[i] == str_array[i - 1] && str_array[i] == str_array[i - 2] && str_array[i] == str_array[i - 3]) continue;
            ret[j++] = str_array[i];
        }
        return new String(ret);
    }
}

