/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.annotation;

import io.choerodon.annotation.entity.PermissionDescription;
import io.choerodon.annotation.entity.PermissionEntity;
import io.choerodon.core.annotation.Dataset;
import io.choerodon.core.annotation.Permission;
import io.choerodon.core.enums.ResourceType;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class PermissionProcessor {
    private PermissionProcessor() {
    }

    public static void resolve(Map<String, Object> controllers, Map<String, PermissionDescription> descriptions) {
        for (Object controller : controllers.values()) {
            PermissionProcessor.resolveClass(controller.getClass(), descriptions);
        }
    }

    public static void resolveClass(Class clazz, Map<String, PermissionDescription> descriptions) {
        Dataset dataset;
        Controller controller = (Controller)AnnotationUtils.findAnnotation((Class)clazz, Controller.class);
        if (controller != null) {
            RequestMapping controllerMapping = (RequestMapping)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)clazz, RequestMapping.class);
            String controllerPath = "";
            if (controllerMapping != null && controllerMapping.value().length > 0) {
                controllerPath = controllerMapping.value()[0];
            }
            for (Method method : clazz.getDeclaredMethods()) {
                PermissionProcessor.resolveMethod(clazz, method, controllerPath, descriptions);
            }
        }
        if ((dataset = (Dataset)AnnotationUtils.findAnnotation((Class)clazz, Dataset.class)) != null) {
            PermissionProcessor.resolveDataset(descriptions, dataset.value());
        }
    }

    private static void resolveDataset(Map<String, PermissionDescription> descriptions, String name) {
        String[] datasetActions;
        for (String action : datasetActions = new String[]{"queries", "mutations", "languages", "validate", "export"}) {
            PermissionDescription description = new PermissionDescription();
            PermissionEntity permissionEntity = new PermissionEntity();
            permissionEntity.setType(ResourceType.SITE.value());
            permissionEntity.setPermissionLogin(false);
            permissionEntity.setPermissionWithin(false);
            permissionEntity.setPermissionPublic(false);
            description.setPath(String.format("/dataset/%s/%s", name, action));
            description.setPermission(permissionEntity);
            description.setMethod("post");
            descriptions.put(String.format("io.cherodon.dataset.%sDatasetController.%s", name, action), description);
        }
    }

    private static void resolveMethod(Class clazz, Method method, String controllerPath, Map<String, PermissionDescription> descriptions) {
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        if (methodMapping != null) {
            String methodPath = "";
            if (methodMapping.value().length > 0) {
                methodPath = methodMapping.value()[0];
            }
            PermissionDescription description = new PermissionDescription();
            description.setPath(PermissionProcessor.processPath(controllerPath + methodPath));
            RequestMethod requestMethod = RequestMethod.GET;
            if (methodMapping.method().length > 0) {
                requestMethod = methodMapping.method()[0];
            }
            description.setMethod(requestMethod.name().toLowerCase());
            Permission permission = (Permission)AnnotationUtils.getAnnotation((Method)method, Permission.class);
            ApiOperation operation = (ApiOperation)AnnotationUtils.getAnnotation((Method)method, ApiOperation.class);
            if (permission != null) {
                PermissionEntity permissionEntity = new PermissionEntity();
                permissionEntity.setRoles(permission.roles());
                permissionEntity.setType(permission.type().value());
                permissionEntity.setPermissionLogin(permission.permissionLogin());
                permissionEntity.setPermissionPublic(permission.permissionPublic());
                permissionEntity.setPermissionWithin(permission.permissionWithin());
                description.setPermission(permissionEntity);
                if (operation != null) {
                    description.setDescription(operation.value());
                }
            }
            descriptions.put(clazz.getName() + "." + method.getName(), description);
        }
    }

    private static String processPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path.replace("//", "/");
    }
}

