/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetBulkSecretRequest;
import io.dapr.client.domain.GetBulkStateRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeMethodRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.utils.TypeRef;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

abstract class AbstractDaprClient
implements DaprClient {
    protected DaprObjectSerializer objectSerializer;
    protected DaprObjectSerializer stateSerializer;

    AbstractDaprClient(DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        this.objectSerializer = objectSerializer;
        this.stateSerializer = stateSerializer;
    }

    @Override
    public Mono<Void> publishEvent(String pubsubName, String topicName, Object data) {
        return this.publishEvent(pubsubName, topicName, data, null);
    }

    @Override
    public Mono<Void> publishEvent(String pubsubName, String topicName, Object data, Map<String, String> metadata) {
        PublishEventRequest req = new PublishEventRequest(pubsubName, topicName, data).setMetadata(metadata);
        return this.publishEvent(req).then();
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object data, HttpExtension httpExtension, Map<String, String> metadata, TypeRef<T> type) {
        InvokeMethodRequest req = new InvokeMethodRequest(appId, methodName).setBody(data).setHttpExtension(httpExtension).setContentType(this.objectSerializer.getContentType());
        return this.invokeMethod(req, type);
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Map<String, String> metadata, Class<T> clazz) {
        return this.invokeMethod(appId, methodName, request, httpExtension, metadata, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata, TypeRef<T> type) {
        return this.invokeMethod(appId, methodName, null, httpExtension, metadata, type);
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata, Class<T> clazz) {
        return this.invokeMethod(appId, methodName, null, httpExtension, metadata, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, TypeRef<T> type) {
        return this.invokeMethod(appId, methodName, request, httpExtension, null, type);
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Class<T> clazz) {
        return this.invokeMethod(appId, methodName, request, httpExtension, null, TypeRef.get(clazz));
    }

    @Override
    public Mono<Void> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension) {
        return this.invokeMethod(appId, methodName, request, httpExtension, null, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<Void> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Map<String, String> metadata) {
        return this.invokeMethod(appId, methodName, request, httpExtension, metadata, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<Void> invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata) {
        return this.invokeMethod(appId, methodName, null, httpExtension, metadata, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<byte[]> invokeMethod(String appId, String methodName, byte[] request, HttpExtension httpExtension, Map<String, String> metadata) {
        return this.invokeMethod(appId, methodName, (Object)request, httpExtension, metadata, TypeRef.BYTE_ARRAY);
    }

    @Override
    public Mono<Void> invokeBinding(String bindingName, String operation, Object data) {
        return this.invokeBinding(bindingName, operation, data, null, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<byte[]> invokeBinding(String bindingName, String operation, byte[] data, Map<String, String> metadata) {
        return this.invokeBinding(bindingName, operation, (Object)data, metadata, TypeRef.BYTE_ARRAY);
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, TypeRef<T> type) {
        return this.invokeBinding(bindingName, operation, data, null, type);
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, Class<T> clazz) {
        return this.invokeBinding(bindingName, operation, data, null, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, Map<String, String> metadata, TypeRef<T> type) {
        InvokeBindingRequest request = new InvokeBindingRequest(bindingName, operation).setData(data).setMetadata(metadata);
        return this.invokeBinding(request, type);
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, Map<String, String> metadata, Class<T> clazz) {
        return this.invokeBinding(bindingName, operation, data, metadata, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, State<T> state, TypeRef<T> type) {
        return this.getState(storeName, state.getKey(), state.getOptions(), type);
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, State<T> state, Class<T> clazz) {
        return this.getState(storeName, state.getKey(), state.getOptions(), TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, TypeRef<T> type) {
        return this.getState(storeName, key, null, type);
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, Class<T> clazz) {
        return this.getState(storeName, key, null, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, StateOptions options, TypeRef<T> type) {
        GetStateRequest request = new GetStateRequest(storeName, key).setStateOptions(options);
        return this.getState(request, type);
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, StateOptions options, Class<T> clazz) {
        return this.getState(storeName, key, options, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<List<State<T>>> getBulkState(String storeName, List<String> keys, TypeRef<T> type) {
        return this.getBulkState(new GetBulkStateRequest(storeName, keys), type);
    }

    @Override
    public <T> Mono<List<State<T>>> getBulkState(String storeName, List<String> keys, Class<T> clazz) {
        return this.getBulkState(storeName, keys, TypeRef.get(clazz));
    }

    @Override
    public Mono<Void> executeStateTransaction(String storeName, List<TransactionalStateOperation<?>> operations) {
        ExecuteStateTransactionRequest request = new ExecuteStateTransactionRequest(storeName).setOperations(operations);
        return this.executeStateTransaction(request).then();
    }

    @Override
    public Mono<Void> saveBulkState(String storeName, List<State<?>> states) {
        SaveStateRequest request = new SaveStateRequest(storeName).setStates(states);
        return this.saveBulkState(request).then();
    }

    @Override
    public Mono<Void> saveState(String storeName, String key, Object value) {
        return this.saveState(storeName, key, null, value, null);
    }

    @Override
    public Mono<Void> saveState(String storeName, String key, String etag, Object value, StateOptions options) {
        State<Object> state = new State<Object>(key, value, etag, options);
        return this.saveBulkState(storeName, Collections.singletonList(state));
    }

    @Override
    public Mono<Void> deleteState(String storeName, String key) {
        return this.deleteState(storeName, key, null, null);
    }

    @Override
    public Mono<Void> deleteState(String storeName, String key, String etag, StateOptions options) {
        DeleteStateRequest request = new DeleteStateRequest(storeName, key).setEtag(etag).setStateOptions(options);
        return this.deleteState(request).then();
    }

    @Override
    public Mono<Map<String, String>> getSecret(String storeName, String key, Map<String, String> metadata) {
        GetSecretRequest request = new GetSecretRequest(storeName, key).setMetadata(metadata);
        return this.getSecret(request).defaultIfEmpty(Collections.emptyMap());
    }

    @Override
    public Mono<Map<String, String>> getSecret(String storeName, String secretName) {
        return this.getSecret(storeName, secretName, null);
    }

    @Override
    public Mono<Map<String, Map<String, String>>> getBulkSecret(String storeName) {
        return this.getBulkSecret(storeName, null);
    }

    @Override
    public Mono<Map<String, Map<String, String>>> getBulkSecret(String storeName, Map<String, String> metadata) {
        GetBulkSecretRequest request = new GetBulkSecretRequest(storeName).setMetadata(metadata);
        return this.getBulkSecret(request).defaultIfEmpty(Collections.emptyMap());
    }
}

