/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprHttp;
import io.dapr.config.Properties;
import java.time.Duration;
import okhttp3.OkHttpClient;

public class DaprHttpBuilder {
    private static volatile OkHttpClient OK_HTTP_CLIENT;
    private static final Object LOCK;

    public DaprHttp build() {
        return this.buildDaprHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaprHttp buildDaprHttp() {
        if (OK_HTTP_CLIENT == null) {
            Object object = LOCK;
            synchronized (object) {
                if (OK_HTTP_CLIENT == null) {
                    OkHttpClient.Builder builder = new OkHttpClient.Builder();
                    Duration readTimeout = Duration.ofSeconds(Properties.HTTP_CLIENT_READ_TIMEOUT_SECONDS.get().intValue());
                    builder.readTimeout(readTimeout);
                    OK_HTTP_CLIENT = builder.build();
                }
            }
        }
        return new DaprHttp(Properties.SIDECAR_IP.get(), Properties.HTTP_PORT.get(), OK_HTTP_CLIENT);
    }

    static {
        LOCK = new Object();
    }
}

