/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.MessageLite;
import io.dapr.client.domain.CloudEvent;
import io.dapr.utils.TypeRef;
import java.io.IOException;
import java.lang.reflect.Method;

public class ObjectSerializer {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    protected ObjectSerializer() {
    }

    public byte[] serialize(Object state) throws IOException {
        if (state == null) {
            return null;
        }
        if (state.getClass() == Void.class) {
            return null;
        }
        if (state instanceof byte[]) {
            return (byte[])state;
        }
        if (state instanceof MessageLite) {
            return ((MessageLite)state).toByteArray();
        }
        return OBJECT_MAPPER.writeValueAsBytes(state);
    }

    public <T> T deserialize(byte[] content, TypeRef<T> type) throws IOException {
        return this.deserialize(content, OBJECT_MAPPER.constructType(type.getType()));
    }

    public <T> T deserialize(byte[] content, Class<T> clazz) throws IOException {
        return this.deserialize(content, OBJECT_MAPPER.constructType(clazz));
    }

    private <T> T deserialize(byte[] content, JavaType javaType) throws IOException {
        if (javaType == null || javaType.isTypeOrSubTypeOf(Void.class)) {
            return null;
        }
        if (javaType.isPrimitive()) {
            return ObjectSerializer.deserializePrimitives(content, javaType);
        }
        if (content == null) {
            return null;
        }
        if (javaType.hasRawClass(byte[].class)) {
            return (T)content;
        }
        if (content.length == 0) {
            return null;
        }
        if (javaType.hasRawClass(CloudEvent.class)) {
            return (T)CloudEvent.deserialize(content);
        }
        if (javaType.isTypeOrSubTypeOf(MessageLite.class)) {
            try {
                Method method = javaType.getRawClass().getDeclaredMethod("parseFrom", byte[].class);
                if (method != null) {
                    return (T)method.invoke(null, new Object[]{content});
                }
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return (T)OBJECT_MAPPER.readValue(content, javaType);
    }

    public JsonNode parseNode(byte[] content) throws IOException {
        return OBJECT_MAPPER.readTree(content);
    }

    private static <T> T deserializePrimitives(byte[] content, JavaType javaType) throws IOException {
        if (content == null || content.length == 0) {
            if (javaType.hasRawClass(Boolean.TYPE)) {
                return (T)Boolean.FALSE;
            }
            if (javaType.hasRawClass(Byte.TYPE)) {
                return (T)Byte.valueOf((byte)0);
            }
            if (javaType.hasRawClass(Short.TYPE)) {
                return (T)Short.valueOf((short)0);
            }
            if (javaType.hasRawClass(Integer.TYPE)) {
                return (T)Integer.valueOf(0);
            }
            if (javaType.hasRawClass(Long.TYPE)) {
                return (T)Long.valueOf(0L);
            }
            if (javaType.hasRawClass(Float.TYPE)) {
                return (T)Float.valueOf(0.0f);
            }
            if (javaType.hasRawClass(Double.TYPE)) {
                return (T)Double.valueOf(0.0);
            }
            if (javaType.hasRawClass(Character.TYPE)) {
                return (T)Character.valueOf('\u0000');
            }
            return null;
        }
        return (T)OBJECT_MAPPER.readValue(content, javaType);
    }
}

